/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf.timeprofile;

import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class DBTimeProfile {
    private static final Logger log = JsonLoggerFactory.getLogger(DBTimeProfile.class);
    private static final ThreadLocal<Stack<TimeProfileStack>> stack = new ThreadLocal();
    private static final ThreadLocal<List<TimeProfileStack>> logs = new ThreadLocal();
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static int threshold = 100;

    public static void enter() {
        DBTimeProfile.enter("");
    }

    public static void enter(String tag) {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = new TimeProfileStack();
        t.setEnterTime(new Date());
        t.setTag(tag);
        t.setDeep(stack.get().size());
        t.index = logs.get().size() + stack.get().size();
        stack.get().push(t);
    }

    public static void release() {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
    }

    public static void start() {
        stack.set(new Stack());
        logs.set(new ArrayList());
        DBTimeProfile.enter();
    }

    public static void end() {
        DBTimeProfile.end("undefined");
    }

    public static void end(String methodName) {
        Stack<TimeProfileStack> s1 = stack.get();
        if (s1 == null) {
            return;
        }
        TimeProfileStack t = s1.pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = t.getReleaseTime().getTime() - t.getEnterTime().getTime();
        if (timeconsume > (long)threshold) {
            StringBuffer sb = new StringBuffer();
            if (request.get() != null) {
                String url = RequestTool.getRequestUrl(request.get());
                sb.append("DBTimeProfile timeout " + timeconsume + "ms >" + threshold + "ms, url=" + url);
            } else {
                sb.append("DBTimeProfile timeout " + timeconsume + "ms > methodName:" + methodName);
            }
            ArrayList list = new ArrayList(logs.get());
            Collections.sort(list, new Comparator<TimeProfileStack>(){

                @Override
                public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                    if (o1.index > o2.index) {
                        return 1;
                    }
                    if (o1.index < o2.index) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (TimeProfileStack s : list) {
                sb.append("\r\n\t");
                for (int i = 0; i < s.getDeep(); ++i) {
                    sb.append("-");
                }
                Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
                sb.append(consume * 100L / timeconsume + "%");
                sb.append("  " + consume + "ms");
                if (s.getTag() != null) {
                    sb.append("  " + s.getTag());
                }
                if (s.getStackTraceElement() == null) continue;
                StackTraceElement ste = s.getStackTraceElement();
                sb.append("  " + ste.getClassName() + "." + ste.getMethodName() + " line:" + ste.getLineNumber());
            }
            log.warn(sb.toString());
        }
        request.set(null);
        stack.set(null);
        logs.set(null);
    }

    public static void setThreshold(int threshold) {
        DBTimeProfile.threshold = threshold;
    }

    public static String dump(long ms) {
        if (logs.get() == null) {
            return null;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = 0L;
        for (TimeProfileStack s : logs.get()) {
            if (s.deep != 0) continue;
            timeconsume = timeconsume + (s.getReleaseTime().getTime() - s.getEnterTime().getTime());
        }
        if (timeconsume < ms) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("DBTimeProfile timeout " + timeconsume + "ms ");
        ArrayList list = new ArrayList(logs.get());
        Collections.sort(list, new Comparator<TimeProfileStack>(){

            @Override
            public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                if (o1.index > o2.index) {
                    return 1;
                }
                if (o1.index < o2.index) {
                    return -1;
                }
                return 0;
            }
        });
        for (TimeProfileStack s : list) {
            Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
            if (consume == 0L) continue;
            sb.append("\r\n\t");
            for (int i = 0; i < s.getDeep(); ++i) {
                sb.append("  ");
            }
            sb.append("-");
            sb.append(consume * 100L / timeconsume + "%");
            sb.append("  " + consume + "ms");
            if (s.getTag() != null) {
                sb.append("  " + s.getTag());
            }
            if (s.getStackTraceElement() == null) continue;
            StackTraceElement ste = s.getStackTraceElement();
            sb.append("  " + ste.getClassName() + "." + ste.getMethodName() + " line:" + ste.getLineNumber());
        }
        request.set(null);
        stack.set(null);
        logs.set(null);
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        DBTimeProfile.start();
        try {
            Thread.sleep(1000L);
            DBTimeProfile.enter("in");
            Thread.sleep(1000L);
            DBTimeProfile.release();
        }
        finally {
            DBTimeProfile.release();
        }
        System.out.println(DBTimeProfile.dump(0L));
    }

    public static class TimeProfileStack {
        private Date enterTime;
        private Date releaseTime;
        private int deep;
        private String tag;
        int index;
        private StackTraceElement stackTraceElement;

        public Date getEnterTime() {
            return this.enterTime;
        }

        public void setEnterTime(Date enterTime) {
            this.enterTime = enterTime;
        }

        public Date getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(Date releaseTime) {
            this.releaseTime = releaseTime;
        }

        public int getDeep() {
            return this.deep;
        }

        public void setDeep(int deep) {
            this.deep = deep;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public void setStackTraceElement(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
        }
    }
}

