/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.cache;

import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duiba.wolf.redis.serializer.Hessian2SerializationRedisSerializer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCacheClient
implements AdvancedCacheClient {
    private RedisTemplate<String, String> redisTemplate;
    private RedisSerializer<String> keyRedisSerializer = new StringRedisSerializer();
    private RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    @Override
    public <T> T get(String key) {
        T t = this.getInner(key);
        if (t != null && t instanceof NullCache) {
            return null;
        }
        return t;
    }

    @Override
    public boolean set(String key, Object value, final int timeout, final TimeUnit unit) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(value);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                this.potentiallyUsePsetEx(connection);
                return null;
            }

            public void potentiallyUsePsetEx(RedisConnection connection) {
                if (!TimeUnit.MILLISECONDS.equals((Object)unit) || !this.failsafeInvokePsetEx(connection)) {
                    connection.setEx(rawKey, TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit), rawValue);
                }
            }

            private boolean failsafeInvokePsetEx(RedisConnection connection) {
                boolean failed = false;
                try {
                    connection.pSetEx(rawKey, (long)timeout, rawValue);
                }
                catch (UnsupportedOperationException e) {
                    failed = true;
                }
                return !failed;
            }
        }, true);
        return true;
    }

    private <T> T getInner(String key) {
        final byte[] rawKey = this.rawKey(key);
        return (T)this.redisTemplate.execute(new RedisCallback<T>(){

            public T doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] valueBytes = connection.get(rawKey);
                return RedisCacheClient.this.valueRedisSerializer.deserialize(valueBytes);
            }
        }, true);
    }

    @Override
    public <T> T getWithCacheLoader(String key, int timeout, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        T value = this.getInner(key);
        if (value == null) {
            value = cacheLoader.load();
            if (isCacheNull) {
                this.setWithNull(key, value, timeout, timeUnit);
            } else {
                this.set(key, value, timeout, timeUnit);
            }
        }
        if (value instanceof NullCache) {
            value = null;
        }
        return value;
    }

    private void setWithNull(String key, Object value, int timeout, TimeUnit unit) {
        if (value == null) {
            value = NullCache.NULL;
        }
        this.set(key, value, timeout, unit);
    }

    @Override
    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader) {
        return this.getWithCacheLoader(key, exp, timeUnit, false, cacheLoader);
    }

    @Override
    public boolean remove(String key) {
        final byte[] rawKey = this.rawKey(key);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.del((byte[][])new byte[][]{rawKey});
                return null;
            }
        }, true);
        return true;
    }

    private byte[] rawKey(String key) {
        return this.keyRedisSerializer.serialize((Object)key);
    }

    private byte[] rawValue(Object value) {
        return this.valueRedisSerializer.serialize(value);
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public static void main(String[] args) throws InterruptedException {
        JedisConnectionFactory factory = new JedisConnectionFactory();
        factory.setHostName("dev.config.duibar.com");
        factory.setPort(6379);
        factory.setPassword("duiba123");
        factory.afterPropertiesSet();
        StringRedisTemplate redisTemplate = new StringRedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)factory);
        redisTemplate.afterPropertiesSet();
        RedisCacheClient redisCacheClient = new RedisCacheClient();
        redisCacheClient.setRedisTemplate((RedisTemplate<String, String>)redisTemplate);
        RedisClient redisClient = new RedisClient(false, "master", "dev.config.duibar.com:6379", "duiba123");
        redisCacheClient.set("name", "hwq", 1000, TimeUnit.MILLISECONDS);
        String value = (String)redisCacheClient.get("name");
        System.out.println(value);
        redisCacheClient.set("name", "100", 10000000, TimeUnit.MILLISECONDS);
        System.out.println(redisClient.get("name"));
        Long result = redisTemplate.opsForValue().increment((Object)"name", 1L);
        value = (String)redisCacheClient.get("name");
        System.out.println(value);
        redisClient.incrBy("name", 1L);
        System.out.println(redisClient.get("name"));
    }

    private static class NullCache
    implements Serializable {
        private static final long serialVersionUID = 1232166518943L;
        public static final NullCache NULL = new NullCache();

        private NullCache() {
        }
    }
}

