/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf.timeprofile;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTimeProfile {
    private static final Logger log = LoggerFactory.getLogger(DBTimeProfile.class);
    private static final ThreadLocal<Stack<TimeProfileStack>> stack = new ThreadLocal();
    private static final ThreadLocal<List<TimeProfileStack>> logs = new ThreadLocal();
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static int threshold = 100;
    private static final String timeout = "DBTimeProfile timeout ";

    private static void enter() {
        DBTimeProfile.enter("");
    }

    public static void enter(String tag) {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = new TimeProfileStack();
        t.setEnterTime(new Date());
        t.setTag(tag);
        t.setDeep(stack.get().size());
        t.index = logs.get().size() + stack.get().size();
        stack.get().push(t);
    }

    public static void release() {
        if (stack.get() == null) {
            return;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
    }

    public static void start() {
        stack.set(new Stack());
        logs.set(new ArrayList());
        DBTimeProfile.enter();
    }

    public static void end() {
        DBTimeProfile.end("undefined");
    }

    public static void end(String methodName) {
        Stack<TimeProfileStack> s1 = stack.get();
        if (s1 == null) {
            return;
        }
        TimeProfileStack t = s1.pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeConsume = t.getReleaseTime().getTime() - t.getEnterTime().getTime();
        if (timeConsume > (long)threshold) {
            StringBuilder sb = new StringBuilder();
            if (request.get() != null) {
                String url = RequestTool.getRequestUrl(request.get());
                sb.append(timeout).append(timeConsume).append("ms >").append(threshold).append("ms, url=").append(url);
            } else {
                sb.append(timeout).append(timeConsume).append("ms > methodName:").append(methodName);
            }
            ArrayList<TimeProfileStack> list = new ArrayList<TimeProfileStack>((Collection)logs.get());
            DBTimeProfile.listSort(list);
            for (TimeProfileStack s : list) {
                sb.append("\r\n\t");
                for (int i = 0; i < s.getDeep(); ++i) {
                    sb.append("-");
                }
                Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
                sb.append(consume * 100L / timeConsume).append("%");
                sb.append("  ").append(consume).append("ms");
                if (s.getTag() != null) {
                    sb.append("  ").append(s.getTag());
                }
                if (s.getStackTraceElement() == null) continue;
                StackTraceElement ste = s.getStackTraceElement();
                sb.append("  ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append(" line:").append(ste.getLineNumber());
            }
            log.warn(sb.toString());
        }
        request.set(null);
        stack.set(null);
        logs.set(null);
    }

    private static void listSort(List<TimeProfileStack> list) {
        Collections.sort(list, new Comparator<TimeProfileStack>(){

            @Override
            public int compare(TimeProfileStack o1, TimeProfileStack o2) {
                if (o1.index > o2.index) {
                    return 1;
                }
                if (o1.index < o2.index) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static void setThreshold(int threshold) {
        DBTimeProfile.threshold = threshold;
    }

    private static String dump() {
        if (logs.get() == null) {
            return null;
        }
        TimeProfileStack t = stack.get().pop();
        t.setReleaseTime(new Date());
        logs.get().add(t);
        Long timeconsume = 0L;
        for (TimeProfileStack s : logs.get()) {
            if (s.deep != 0) continue;
            timeconsume = timeconsume + (s.getReleaseTime().getTime() - s.getEnterTime().getTime());
        }
        if (timeconsume < 0L) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(timeout).append(timeconsume).append("ms ");
        ArrayList<TimeProfileStack> list = new ArrayList<TimeProfileStack>((Collection)logs.get());
        DBTimeProfile.listSort(list);
        for (TimeProfileStack s : list) {
            Long consume = s.getReleaseTime().getTime() - s.getEnterTime().getTime();
            if (consume == 0L) continue;
            sb.append("\r\n\t");
            for (int i = 0; i < s.getDeep(); ++i) {
                sb.append("  ");
            }
            sb.append("-");
            sb.append(consume * 100L / timeconsume).append("%");
            sb.append("  ").append(consume).append("ms");
            if (s.getTag() != null) {
                sb.append("  ").append(s.getTag());
            }
            if (s.getStackTraceElement() == null) continue;
            StackTraceElement ste = s.getStackTraceElement();
            sb.append("  ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append(" line:").append(ste.getLineNumber());
        }
        request.set(null);
        stack.set(null);
        logs.set(null);
        return sb.toString();
    }

    public static class TimeProfileStack {
        private Date enterTime;
        private Date releaseTime;
        private int deep;
        private String tag;
        int index;
        private StackTraceElement stackTraceElement;

        Date getEnterTime() {
            return this.enterTime;
        }

        void setEnterTime(Date enterTime) {
            this.enterTime = enterTime;
        }

        Date getReleaseTime() {
            return this.releaseTime;
        }

        void setReleaseTime(Date releaseTime) {
            this.releaseTime = releaseTime;
        }

        int getDeep() {
            return this.deep;
        }

        void setDeep(int deep) {
            this.deep = deep;
        }

        String getTag() {
            return this.tag;
        }

        void setTag(String tag) {
            this.tag = tag;
        }

        StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public void setStackTraceElement(StackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
        }
    }
}

