package cn.com.duiba.wolf.cache;

import cn.com.duiba.boot.ext.autoconfigure.redis.Hessian2SerializationRedisSerializer;
import cn.com.duiba.catmonitor.CatInstance;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.entity.Null;
import cn.com.duiba.wolf.log.DegradeLogger;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisClient;
import com.dianping.cat.Cat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.Jedis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 2017/1/11.
 */
public class RedisCacheClient implements AdvancedCacheClient {

    private static final Logger logger = DegradeLogger.wrap(LoggerFactory.getLogger(RedisCacheClient.class));

    private final RedisTemplate redisTemplate;

    private RedisSerializer<String> keyRedisSerializer = new StringRedisSerializer();
    private RedisSerializer<Object> valueRedisSerializer = new Hessian2SerializationRedisSerializer();

    public RedisCacheClient(RedisTemplate redisTemplate){
        this.redisTemplate = redisTemplate;
    }

    @Override
    public <T> T get(String key) {
        T t = getInner(key);
        if(t != null && t instanceof Null){//如果取回的数据是NullCache,表示是之前故意放入的,特殊处理,返回null
            return null;
        }
        return t;
    }

    @Override
    public boolean set(final String key, final Object value, final int timeout, final TimeUnit unit) {
        if(value == null){
            return false;
        }

        final byte[] rawKey = rawKey(key);
        final byte[] rawValue = rawValue(value);

        try {
            redisTemplate.execute(new RedisCallback<Object>() {

                public Object doInRedis(RedisConnection connection) throws DataAccessException {

                    potentiallyUsePsetEx(connection);
                    return null;
                }

                public void potentiallyUsePsetEx(RedisConnection connection) {

                    if (!TimeUnit.MILLISECONDS.equals(unit) || !failsafeInvokePsetEx(connection)) {
                        connection.setEx(rawKey, TimeoutUtils.toSeconds(timeout, unit), rawValue);
                    }
                }

                private boolean failsafeInvokePsetEx(RedisConnection connection) {

                    boolean failed = false;
                    try {
                        connection.pSetEx(rawKey, timeout, rawValue);
                    } catch (UnsupportedOperationException e) {
                        // in case the connection does not support pSetEx return false to allow fallback to other operation.
                        failed = true;
                    }
                    return !failed;
                }

            }, true);
        } catch(Exception e){
            logger.error("", e);
            if(CatInstance.isEnable()) {
                Cat.logError(e);
            }
            return false;
        }

        return true;
    }

    private <T> T getInner(String key) {
        final byte[] rawKey = rawKey(key);
        try {
            return (T)redisTemplate.execute(new RedisCallback<T>() {
                @Override
                public T doInRedis(RedisConnection connection) throws DataAccessException {
                    byte[] valueBytes = connection.get(rawKey);
                    return (T) valueRedisSerializer.deserialize(valueBytes);
                }
            }, true);
        } catch(Exception e){
            logger.error("get key error:"+key, e);
            if(CatInstance.isEnable()) {
                Cat.logError(e);
            }
            return null;
        }
    }

    @Override
    public <T> T getWithCacheLoader(String key, int timeout, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        T value = getInner(key);
        if(value == null){
            value = cacheLoader.load();
            if(isCacheNull) {
                setWithNull(key, value, timeout, timeUnit);
            }else if(value != null){
                set(key, value, timeout, timeUnit);
            }
        }

        if(value instanceof Null){//如果取回的数据是NullCache,表示是之前故意放入的,特殊处理,返回null
            value = null;
        }

        return value;
    }

    protected void setWithNull(String key, Object value, int timeout, TimeUnit unit) {
        if (value == null) {
            value = Null.NULL;
        }
        set(key, value, timeout, unit);
    }

    @Override
    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader) {
        return getWithCacheLoader(key, exp, timeUnit, false, cacheLoader);
    }

    @Override
    public boolean remove(String key) {
        final byte[] rawKey = rawKey(key);
        try {
            redisTemplate.execute(new RedisCallback<Object>() {

                @Override
                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.del(rawKey);
                    return null;
                }
            }, true);
        } catch(Exception e){
            logger.error("", e);
            if(CatInstance.isEnable()) {
                Cat.logError(e);
            }
            return false;
        }
        return true;
    }

    private byte[] rawKey(String key){
        return keyRedisSerializer.serialize(key);
    }

    private byte[] rawValue(Object value){
        return valueRedisSerializer.serialize(value);
    }

    public static void main(String[] args) throws InterruptedException {
        JedisConnectionFactory factory = new JedisConnectionFactory();
        factory.setHostName("dev.config.duibar.com");
        factory.setPort(6379);
        factory.setPassword("duiba123");
        factory.setTimeout(100);
        factory.setUsePool(true);
        factory.getPoolConfig().setMaxWaitMillis(0);
        factory.getPoolConfig().setMaxIdle(10);
        factory.getPoolConfig().setMaxTotal(10);
        factory.getPoolConfig().setMinIdle(0);
        factory.afterPropertiesSet();
        final StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory(factory);
        stringRedisTemplate.afterPropertiesSet();
        RedisCacheClient redisCacheClient = new RedisCacheClient(stringRedisTemplate);

        String ret22 = stringRedisTemplate.execute(new RedisCallback<String>() {

            @Override
            public String doInRedis(RedisConnection redisConnection) throws DataAccessException {
                Jedis jedis = (Jedis)redisConnection.getNativeConnection();
                stringRedisTemplate.opsForValue().get("a");
                return jedis.set("aa" + "bb", "locked", "NX", "EX", 20);
            }
        });
        if ("OK".equals(ret22)) {
            System.out.println("-----true");
        }

        stringRedisTemplate.opsForValue().getOperations().delete("hello");
        List<String> keys=new ArrayList<>();
        keys.add("hello");
        Long ret1 = stringRedisTemplate.execute(new DefaultRedisScript<Long>("local v\n" +
                "v = redis.call(\"incrBy\",KEYS[1],ARGV[1])\n" +
                "if tonumber(v) == 1 then\n" +
                "    redis.call(\"expire\",KEYS[1],ARGV[2])\n" +
                "end\n" +
                "return v", Long.class),keys,"1","3600");
        ret1 = stringRedisTemplate.execute(new DefaultRedisScript<Long>("local v; v = redis.call('incrBy',KEYS[1],ARGV[1])" +
                "\n" +
                "if tonumber(v) == 1 then\n" +
                "    redis.call('expire',KEYS[1],ARGV[2])\n" +
                "end\n" +
                "return v", Long.class),keys,"1","10");
        System.out.println(ret1);
        System.out.println(stringRedisTemplate.getExpire("hello", TimeUnit.SECONDS));

        stringRedisTemplate.opsForValue().getOperations().delete("hello");
        RedisAtomicClient redisAtomicClient = new RedisAtomicClient(stringRedisTemplate);
        Long ret2 = redisAtomicClient.incrBy("hello", 1, 1, TimeUnit.MINUTES);
        ret2 = redisAtomicClient.incrBy("hello", 1, 1, TimeUnit.MINUTES);
        System.out.println(ret2);
        System.out.println(redisAtomicClient.getLong("hello"));
        System.out.println(stringRedisTemplate.getExpire("hello", TimeUnit.SECONDS));


        redisCacheClient.set("hello",1,10,TimeUnit.SECONDS);
        //stringRedisTemplate.opsForValue().set("hello",String.valueOf(1));
        long ret = 0;//stringRedisTemplate.opsForValue().increment("hello",1);
        System.out.println(Integer.valueOf(stringRedisTemplate.opsForValue().get("hello")));
        if(ret == 1){
            System.out.println("ret == 1");
            stringRedisTemplate.opsForValue().getOperations().expire("hello",5, TimeUnit.SECONDS);
        }
        Thread.sleep(3000);
        stringRedisTemplate.opsForValue().increment("hello",2);
        Thread.sleep(3000);
        System.out.println(stringRedisTemplate.opsForValue().get("hello"));
        stringRedisTemplate.opsForValue().increment("hello",-1);
        System.out.println(Integer.valueOf(stringRedisTemplate.opsForValue().get("hello")));
        stringRedisTemplate.opsForValue().getOperations().delete("hello");
        System.out.println(stringRedisTemplate.opsForValue().get("hello"));

        String key = "sfds";
        stringRedisTemplate.opsForValue().increment(key, 1);

        setByCas(stringRedisTemplate, key, 5, 1);
        setByCas(stringRedisTemplate, key, 5, 1);
        setByCas(stringRedisTemplate, key, 5, 1);
        setByCas(stringRedisTemplate, key, 5, 1);
        setByCas(stringRedisTemplate, key, 5, 1);

        setByCas(stringRedisTemplate, key, 0, -1);
        setByCas(stringRedisTemplate, key, 0, -1);
        setByCas(stringRedisTemplate, key, 0, -1);
        setByCas(stringRedisTemplate, key, 0, -1);
        setByCas(stringRedisTemplate, key, 0, -1);
        setByCas(stringRedisTemplate, key, 0, -1);

        stringRedisTemplate.opsForHash().increment("a","1",1);
        System.out.println("a,1:"+stringRedisTemplate.opsForHash().get("a","1"));
        System.out.println("a,'1':"+stringRedisTemplate.opsForHash().get("a","1"));
        stringRedisTemplate.opsForHash().increment("a","1",1);
        System.out.println("a,1:"+stringRedisTemplate.opsForHash().get("a","1"));
        System.out.println("a,'1':"+stringRedisTemplate.opsForHash().get("a","1"));


        RedisClient redisClient = new RedisClient(false,"master","dev.config.duibar.com:6379","duiba123");

        redisCacheClient.set("name","hwq", 1000, TimeUnit.MILLISECONDS);
        String value = redisCacheClient.get("name");
        System.out.println(value);
        redisCacheClient.remove("name");
        value = redisCacheClient.get("name");
        System.out.println(value);

        redisCacheClient.set("name","100", 10000000, TimeUnit.MILLISECONDS);
        System.out.println(redisClient.get("name"));

        DubboResult d = DubboResult.failResult("???jjjj");
        redisCacheClient.set("name",d, 10000000, TimeUnit.MILLISECONDS);
        d = redisCacheClient.get("name");
        System.out.println(d.getMsg());

        RedisTemplate<String, DubboResult> redisTemplate = new RedisTemplate<String, DubboResult>();
        redisTemplate.setEnableDefaultSerializer(false);
        redisTemplate.setKeySerializer(new StringRedisSerializer());
        redisTemplate.setValueSerializer(new Hessian2SerializationRedisSerializer());
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.afterPropertiesSet();

        d = redisTemplate.opsForValue().get("name");
        System.out.println(d.getMsg());

    }

    private static Integer setByCas(StringRedisTemplate stringRedisTemplate,final String key, final int limit, final int type) {
        String cStr = stringRedisTemplate.opsForValue().get(key);
        Integer count;
        if(cStr != null){
            count = Integer.valueOf(cStr);
        }else {
            return 2;//缓存对象为空
        }

        if(type>0){
            if(count == null || count < limit){
                long currentCount = stringRedisTemplate.opsForValue().increment(key, 1);
                if(currentCount > limit){
                    stringRedisTemplate.opsForValue().increment(key, -1);
                    return 3;//超出限制
                }
                return 0; //更新成功
            }else if(count > limit){
                stringRedisTemplate.opsForValue().increment(key, -1);
            }
            return 3;//超出限制
        }else if(type<0){
            if(count == null || count > limit){
                long currentCount = stringRedisTemplate.opsForValue().increment(key, -1);
                if(currentCount < limit){
                    stringRedisTemplate.opsForValue().increment(key, 1);
                    return 3;//超出限制
                }
                return 0; //更新成功
            }else if(count < limit){
                stringRedisTemplate.opsForValue().increment(key, 1);
            }
            return 3;//超出限制
        }
        return 4;//参数错误
    }
}
