package cn.com.duiba.wolf.degrade;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

/**
 * Created by xuezhaoming on 16/6/7.
 */
public abstract class DegradeTemplate<T> {

    private Cache<Object, Lock> build = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.HOURS).build();

    public T execute() {

        T result = null;
        try {
            result = doNormal();

        } catch (Exception e) {

            Lock lock = null;
            try {
                lock = build.get(getKey(), new Callable<Lock>() {

                    @Override
                    public Lock call() throws Exception {
                        return new ReentrantLock();
                    }
                });

                if (lock.tryLock()) {
                    result = doError();
                }
            } catch (ExecutionException e1) {

            } finally {
                lock.unlock();
            }

        }

        return result;
    }

    /**
     * 获取对象锁
     * 
     * @return
     */
    public abstract Object getKey();

    /**
     * 正常业务逻辑处理
     * 
     * @return
     */
    public abstract T doNormal();

    /**
     * 异常错误处理
     * 
     * @return
     */
    public abstract T doError();

}
