/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.EnvInfo;
import cn.com.duiba.wolf.dubbo.RuntimeExceptionFilter;
import cn.com.duiba.wolf.dubbo.VersionCheck;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javassist.ClassPool;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.context.ApplicationContext;

public class InitOperation {
    private static final Logger LOG = LoggerFactory.getLogger(InitOperation.class);
    private static volatile boolean initialized = false;
    private static final String DEFAULT_PATH = "/META-INF/wolf/wolf.properties";
    public static final int DEFAULT_THRESHOLD = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() {
        if (initialized) {
            return;
        }
        LOG.info(" ----------- start class file  duplicate check   -----------");
        String configPath = System.getProperty("wolf.properties", DEFAULT_PATH);
        VersionCheck.checkDuplicate(Logger.class);
        VersionCheck.checkDuplicate(Preconditions.class);
        VersionCheck.checkDuplicate(ApplicationConfig.class);
        VersionCheck.checkDuplicate(ApplicationContext.class);
        VersionCheck.checkDuplicate(BeanInfoFactory.class);
        VersionCheck.checkDuplicate("org.junit.Assume.class");
        VersionCheck.checkDuplicate(ClassPool.class);
        VersionCheck.checkDuplicate(DEFAULT_PATH);
        VersionCheck.checkDuplicate(configPath);
        LOG.info(" ----------- end class file  duplicate check   -----------");
        LOG.info(" ----------- start init config  -----------");
        int threshold = 500;
        String dubboSystemName = "--";
        InputStream propertiesInputStream = InitOperation.class.getResourceAsStream(configPath);
        if (propertiesInputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(propertiesInputStream);
                String thresholdStr = properties.getProperty("timeprofile.threshold");
                String dubboSystemNameTemp = properties.getProperty("dubbo.system.name");
                if (!StringUtils.isBlank((String)dubboSystemNameTemp)) {
                    dubboSystemName = dubboSystemNameTemp;
                }
                if (NumberUtils.isNumber((String)thresholdStr)) {
                    threshold = Integer.valueOf(thresholdStr);
                }
            }
            catch (Exception e) {
                LOG.error(" ----------- init time profile  error !  -----------" + EnvInfo.getEnvInfo(), (Throwable)e);
            }
            finally {
                if (propertiesInputStream != null) {
                    try {
                        propertiesInputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn("close InputStream error . from : /META-INF/wolf/wolf.properties  " + EnvInfo.getEnvInfo());
                    }
                }
                LOG.info("threshold info {}", (Object)threshold);
            }
        }
        DBTimeProfile.setThreshold(threshold);
        RuntimeExceptionFilter.registerSystemName(dubboSystemName);
        LOG.info(" ----------- end of  init   config  -----------");
        initialized = true;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        try {
            properties.load(InitOperation.class.getResourceAsStream(DEFAULT_PATH));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(properties.isEmpty());
    }
}

