/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf.timeprofile;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class RequestTool {
    public static String getUserAgent(HttpServletRequest req) {
        if (req != null) {
            return req.getHeader("User-Agent");
        }
        return null;
    }

    public static String getFullRequestUrl(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return url;
        }
        return url + "?" + queryString;
    }

    public static String getRequestUrl(HttpServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (path == null) {
            return request.getRequestURL().toString();
        }
        StringBuilder url = new StringBuilder(RequestTool.getServerPath(request)).append(path);
        Map map = request.getParameterMap();
        if (!map.isEmpty()) {
            url.append("?");
        }
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (((String[])entry.getValue()).length <= 0) continue;
            String key = (String)entry.getKey();
            if (i > 0) {
                url.append("&");
            }
            url.append(key).append("=").append(((String[])entry.getValue())[0]);
            ++i;
        }
        return url.toString();
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (RequestTool.isInvalidIp(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (RequestTool.isInvalidIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (RequestTool.isInvalidIp(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (RequestTool.isInvalidIp(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (RequestTool.isInvalidIp(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static boolean isInvalidIp(String ip) {
        return ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip);
    }

    public static boolean isProxy(HttpServletRequest request) {
        String[] ips;
        long sizeOfForwardFor;
        String httpVia = request.getHeader("HTTP_VIA");
        if (httpVia != null && !"".equals(httpVia)) {
            return true;
        }
        String xForwardedFor = request.getHeader("x-forwarded-for");
        return xForwardedFor != null && xForwardedFor.trim().length() > 0 && (sizeOfForwardFor = (long)(ips = xForwardedFor.trim().split(",")).length) > 1L;
    }

    public static String getOS(HttpServletRequest request) {
        String ua = RequestTool.getUserAgent(request);
        if (ua == null) {
            return "Unkonwn";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad")) {
                return "iPad";
            }
            if (ua.contains("iphone")) {
                return "iPhone";
            }
            if (ua.contains("android")) {
                return "Android";
            }
            if (ua.contains("linux")) {
                return "Linux";
            }
            if (ua.contains("windows")) {
                return "Windows";
            }
            if (ua.contains("macintosh")) {
                return "Mac";
            }
        }
        return "Unknown";
    }

    public static String getSimpleOs(HttpServletRequest request) {
        String ua = RequestTool.getUserAgent(request);
        if (ua == null) {
            return "unkonwn";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad") || ua.contains("iphone") || ua.contains("macintosh")) {
                return "ios";
            }
            if (ua.contains("android")) {
                return "android";
            }
        }
        return "unknown";
    }

    public static String getOSNew(HttpServletRequest request) {
        String ua = RequestTool.getUserAgent(request);
        return RequestTool.getOSNew(ua);
    }

    public static String getOSNew(String ua) {
        if (ua == null) {
            return "6";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad")) {
                return "4";
            }
            if (ua.contains("iphone")) {
                return "1";
            }
            if (ua.contains("android")) {
                return "0";
            }
            if (ua.contains("linux")) {
                return "5";
            }
            if (ua.contains("windows")) {
                return "2";
            }
            if (ua.contains("macintosh")) {
                return "3";
            }
            if (ua.contains("ios")) {
                return "6";
            }
        }
        return "6";
    }

    public static boolean isLocalRequest(HttpServletRequest request) {
        String ip = RequestTool.getIpAddr(request);
        return ip.startsWith("127.0.0.1") || ip.startsWith("0:0:0:0");
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                String value;
                Cookie c = cookies[i];
                if (!name.equals(c.getName()) || (value = c.getValue()) == null || value.length() <= 0) continue;
                return value;
            }
        }
        return null;
    }

    public static String getServerPath(HttpServletRequest request) {
        String port = String.valueOf(request.getServerPort());
        port = "80".equals(port) && "http".equals(request.getScheme()) || "443".equals(port) && "https".equals(request.getScheme()) ? "" : ":" + port;
        return request.getScheme() + "://" + request.getServerName() + port;
    }

    public static boolean isIos(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String ua = RequestTool.getUserAgent(request);
        if (ua == null) {
            return false;
        }
        return (ua = ua.toLowerCase()).contains("iphone") || ua.contains("ipad") || ua.contains("macintosh");
    }

    public static boolean isAndroid(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        String ua = RequestTool.getUserAgent(request);
        if (ua == null) {
            return false;
        }
        ua = ua.toLowerCase();
        return ua.contains("android");
    }
}

