/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final SimpleDateFormat DAY = DateUtils.getFormat("yyyy-MM-dd");
    private static final SimpleDateFormat DAY_NUMBER = DateUtils.getFormat("yyyyMMdd");
    private static final SimpleDateFormat YEAR_DAY_NUMBER = DateUtils.getFormat("yyMMdd");
    private static final SimpleDateFormat YEAR = DateUtils.getFormat("yyyy");
    private static final SimpleDateFormat DAY_ONLY = DateUtils.getFormat("MM-dd");
    private static final SimpleDateFormat SECOND = DateUtils.getFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat SECOND_ONLY = DateUtils.getFormat("HH:mm:ss");
    private static final SimpleDateFormat MINUTE = DateUtils.getFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat MINUTE_ONLY = DateUtils.getFormat("HH:mm");
    private static final SimpleDateFormat MINUTE_ANOTHER = DateUtils.getFormat("yyyyMMdd-HHmm");
    private static final SimpleDateFormat MONTH_DAY_YEAR = DateUtils.getFormat("MM/dd/yyyy");
    private static final SimpleDateFormat MILLI_SECOND = DateUtils.getFormat("yyyyMMddHHmmssSSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYearStr(Date date) {
        SimpleDateFormat simpleDateFormat = YEAR;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, YEAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getYearStr(long date) {
        SimpleDateFormat simpleDateFormat = YEAR;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(new Date(date), YEAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMinuteDbStr(Date date) {
        SimpleDateFormat simpleDateFormat = MINUTE_ANOTHER;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, MINUTE_ANOTHER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getMinuteDbDate(String str) {
        SimpleDateFormat simpleDateFormat = MINUTE_ANOTHER;
        synchronized (simpleDateFormat) {
            return DateUtils.getDate(str, MINUTE_ANOTHER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getMonDayYearDate(String str) {
        SimpleDateFormat simpleDateFormat = MONTH_DAY_YEAR;
        synchronized (simpleDateFormat) {
            return DateUtils.getDate(str, MONTH_DAY_YEAR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecondOnlyStr(Date date) {
        SimpleDateFormat simpleDateFormat = SECOND_ONLY;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, SECOND_ONLY);
        }
    }

    public static String getSecondOnlyStr(long date) {
        return DateUtils.getSecondOnlyStr(new Date(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOnlyDayStr(long date) {
        SimpleDateFormat simpleDateFormat = DAY_ONLY;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(new Date(date), DAY_ONLY);
        }
    }

    public static String getSecondStr(long date) {
        return DateUtils.getSecondStr(new Date(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecondStr(Date date) {
        SimpleDateFormat simpleDateFormat = SECOND;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, SECOND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMinuteStr(Date date) {
        SimpleDateFormat simpleDateFormat = MINUTE;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, MINUTE);
        }
    }

    public static String getMinuteStr(long date) {
        return DateUtils.getMinuteStr(new Date(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMinuteOnlyStr(Date date) {
        SimpleDateFormat simpleDateFormat = MINUTE_ONLY;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, MINUTE_ONLY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDayStr(Date date) {
        SimpleDateFormat simpleDateFormat = DAY;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, DAY);
        }
    }

    public static String getDayStr(long date) {
        return DateUtils.getDayStr(new Date(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDayNumber(Date date) {
        if (date == null) {
            return 0;
        }
        SimpleDateFormat simpleDateFormat = DAY_NUMBER;
        synchronized (simpleDateFormat) {
            return Integer.valueOf(DateUtils.getStr(date, DAY_NUMBER));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getYYDayNumber(Date date) {
        if (date == null) {
            return 0;
        }
        SimpleDateFormat simpleDateFormat = YEAR_DAY_NUMBER;
        synchronized (simpleDateFormat) {
            return Integer.valueOf(DateUtils.getStr(date, YEAR_DAY_NUMBER));
        }
    }

    public static Date getDayDate(Date date) {
        return DateUtils.getDayDate(DateUtils.getDayStr(date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getSecondDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = SECOND;
        synchronized (simpleDateFormat) {
            return DateUtils.getDate(dateStr, SECOND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDayDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = DAY;
        synchronized (simpleDateFormat) {
            return DateUtils.getDate(dateStr, DAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getMinuteOnlyDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = MINUTE_ONLY;
        synchronized (simpleDateFormat) {
            return DateUtils.getDate(dateStr, MINUTE_ONLY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getMinuteDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = MINUTE;
        synchronized (simpleDateFormat) {
            return DateUtils.getDate(dateStr, MINUTE);
        }
    }

    public static Date getMinuteDate(long time) {
        return DateUtils.getMinuteDate(DateUtils.getMinuteStr(time));
    }

    public static long getMiniteDate(Date date, String str) {
        if (str == null) {
            return 0L;
        }
        Date date1 = DateUtils.getMinuteDate(DateUtils.getDayStr(date) + " " + str);
        if (date1 == null) {
            return 0L;
        }
        return date1.getTime();
    }

    public static Date monthsAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 2, offset);
    }

    public static Date daysAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 5, offset);
    }

    public static Date hoursAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 11, offset);
    }

    public static Date minutesAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 12, offset);
    }

    public static Date secondsAddOrSub(Date date, int offset) {
        return DateUtils.addOrSub(date, 13, offset);
    }

    public static boolean isTimeString(String toCheck) {
        if (!StringUtils.isNotBlank((String)toCheck)) {
            return false;
        }
        return toCheck.trim().matches("([0-1][0-9]|2[0-3]):[0-5][0-9]|24:00");
    }

    public static int compareHHmmInString(String ts1, String ts2) {
        return ts1.compareTo(ts2);
    }

    public static int betweenHHmmInString(String ts, String start, String end) {
        if (DateUtils.compareHHmmInString(start, end) >= 0) {
            return -1;
        }
        if (DateUtils.compareHHmmInString(ts, start) < 0) {
            return 0;
        }
        if (DateUtils.compareHHmmInString(end, ts) <= 0) {
            return 0;
        }
        return 1;
    }

    public static boolean equalsInTimeString(String ts1, String ts2) {
        if (ts1.equals(ts2)) {
            return true;
        }
        return !(!"00:00".equals(ts1) && !"24:00".equals(ts1) || !"00:00".equals(ts2) && !"24:00".equals(ts2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMillisecond() {
        SimpleDateFormat simpleDateFormat = MILLI_SECOND;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(new Date(), MILLI_SECOND);
        }
    }

    public static int compareHHmm(Calendar cal, Calendar c) {
        if (cal.get(11) > c.get(11)) {
            return 1;
        }
        if (cal.get(11) == c.get(11)) {
            if (cal.get(12) > c.get(12)) {
                return 1;
            }
            if (cal.get(12) == c.get(12)) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public static int betweenHHmm(Calendar cal, Calendar start, Calendar end) {
        if (DateUtils.compareHHmm(start, end) != -1) {
            return -1;
        }
        if (DateUtils.compareHHmm(cal, start) == -1) {
            return 0;
        }
        if (DateUtils.compareHHmm(end, cal) == -1) {
            return 0;
        }
        return 1;
    }

    public static boolean compareDay(Calendar cal, Calendar c) {
        return cal.get(1) == c.get(1) && cal.get(2) == c.get(2) && cal.get(5) == c.get(5);
    }

    public static Calendar string2calendar(String timeString) throws Exception {
        if (!DateUtils.isTimeString(timeString)) {
            throw new Exception("Wrong argument : timeString format error " + timeString);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, DateUtils.getHour(timeString));
        cal.set(12, DateUtils.getMinute(timeString));
        return cal;
    }

    public static String calendar2TimeString(Calendar cal) {
        return (cal.get(11) > 9 ? Integer.valueOf(cal.get(11)) : "0" + cal.get(11)) + ":" + (cal.get(12) > 9 ? Integer.valueOf(cal.get(12)) : "0" + cal.get(12));
    }

    public static int getHour(String timeString) {
        return Integer.parseInt(timeString.substring(0, 2));
    }

    public static int getMinute(String timeString) {
        return Integer.parseInt(timeString.substring(3, 5));
    }

    public static String getDateOnlyFromDate(String dateString) {
        return dateString.substring(5, 10);
    }

    public static String calendar2DateString(Calendar cal) {
        return (cal.get(2) + 1 > 9 ? Integer.valueOf(cal.get(2) + 1) : "0" + (cal.get(2) + 1)) + "-" + (cal.get(5) > 9 ? Integer.valueOf(cal.get(5)) : "0" + cal.get(5));
    }

    public static Integer monthSub(Date beginDate, Date endDate) {
        Integer monthNum = 0;
        Integer yearNumber = 0;
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(beginDate);
        endCalendar.setTime(endDate);
        yearNumber = endCalendar.get(1) - startCalendar.get(1);
        monthNum = endCalendar.get(2) - startCalendar.get(2);
        return yearNumber * 12 + monthNum;
    }

    public static Date getMonthDayByIndex(Date beginDate, int index) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(beginDate);
        cal.set(5, index);
        return cal.getTime();
    }

    public static Map<String, Date> retTodayAndTomorrow() {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        Date start = DateUtils.getDayDate(new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        cal.add(5, 1);
        Date end = cal.getTime();
        dateMap.put("startDay", start);
        dateMap.put("endDay", end);
        return dateMap;
    }

    public static int getToTomorrowSeconds() {
        Calendar curDate = Calendar.getInstance();
        GregorianCalendar tommorowDate = new GregorianCalendar(curDate.get(1), curDate.get(2), curDate.get(5) + 1, 0, 0, 0);
        return (int)((tommorowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000L);
    }

    public static long getTodayZeroTimeInMillis() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long getMonthFirstDayTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long getNextMonthFirstDayTimeInMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long getDifferDay(Date date) {
        Date nowDate = new Date();
        if (nowDate.after(date)) {
            return 0L;
        }
        return Math.abs(date.getTime() - nowDate.getTime()) / 86400000L + (long)(Math.abs(date.getTime() - nowDate.getTime()) % 86400000L == 0L ? 0 : 1);
    }

    private static Date addOrSub(Date date, int type, int offset) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.get(type);
        cal.set(type, cal.get(type) + offset);
        return cal.getTime();
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static Date getDate(String dateStr, SimpleDateFormat format) {
        if ("".equals(dateStr) || dateStr == null) {
            return null;
        }
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            LOG.error("format yyyy-MM-dd HH:mm:ss error:", (Throwable)e);
            return null;
        }
    }

    public static Date getMondayDate(Date day) {
        Calendar calWeek = Calendar.getInstance();
        calWeek.setTime(day);
        if (1 == calWeek.get(7)) {
            calWeek.add(5, -6);
        } else if (2 == calWeek.get(7)) {
            calWeek.add(5, -7);
        } else if (3 == calWeek.get(7)) {
            calWeek.add(5, -1);
        } else if (4 == calWeek.get(7)) {
            calWeek.add(5, -2);
        } else if (5 == calWeek.get(7)) {
            calWeek.add(5, -3);
        } else if (6 == calWeek.get(7)) {
            calWeek.add(5, -4);
        } else if (7 == calWeek.get(7)) {
            calWeek.add(5, -5);
        }
        return DateUtils.getDayDate(calWeek.getTime());
    }

    public static Date getFirstDayDate(Date day) {
        Calendar calMonth = Calendar.getInstance();
        calMonth.setTime(day);
        if (1 == calMonth.get(5)) {
            calMonth.setTime(DateUtils.daysAddOrSub(day, -1));
        }
        calMonth.set(5, 1);
        return DateUtils.getDayDate(calMonth.getTime());
    }

    public static Date getStartTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndTime(Date date) {
        if (null == date) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getEndTime(String strDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.getDayDate(strDate));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static Date getStartTime(String strDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.getDayDate(strDate));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static int daysBetween(Date smdate, Date bdate) {
        smdate = DateUtils.getDayDate(smdate);
        bdate = DateUtils.getDayDate(bdate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date changeByDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static String getYesterday() {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        date.set(5, date.get(5) - 1);
        Date endDate = null;
        try {
            endDate = dft.parse(dft.format(date.getTime()));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return dft.format(endDate);
    }
}

