package cn.com.duiba.wolf.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * 镜像比较
 * @author xuhengfei
 *
 */
public class MirrorEqualsUtils {

    private static final Logger logger = LoggerFactory.getLogger(MirrorEqualsUtils.class);
    /**
     * 比较两个BEAN或MAP对象的值是否相等
     * 如果是BEAN与MAP对象比较时MAP中的key值应与BEAN的属性值名称相同且字段数目要一致
     * @param source
     * @param target
     * @return
     */
    public static boolean mirrorEquals(Object source, Object target) {
        if (source == null || target == null) {
            return false;
        }
        boolean rv = true;
        if (source instanceof Map) {
            rv = mapOfSrc(source, target, rv);
        } else {
            rv = classOfSrc(source, target, rv);
        }
        return rv;
    }

    /**
     * 源目标为MAP类型时
     * @param source
     * @param target
     * @param rv
     * @return
     */
    private static boolean mapOfSrc(Object source, Object target, boolean rv) {
        boolean result = rv;
        HashMap<String, String> map = (HashMap) source;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (target instanceof Map) {
                HashMap<String, String> tarMap = (HashMap) target;
                if(tarMap.get(key)==null || !value.equals(tarMap.get(key))){
                    result = false;
                    break;
                }
            } else {
                Object tarObj = getClassValue(target, key);
                String tarValue = tarObj == null ? "" : tarObj.toString();
                if (!tarValue.equals(value)) {
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    /**
     * 源目标为非MAP类型时
     * @param source
     * @param target
     * @param rv
     * @return
     */
    private static boolean classOfSrc(Object source, Object target, boolean rv) {
        boolean result = rv;
        Class<?> srcClass = source.getClass();
        Field[] fields = srcClass.getDeclaredFields();
        for (Field field : fields) {
            String nameKey = field.getName();
            if (target instanceof Map) {
                HashMap<String, String> tarMap = (HashMap) target;
                Object srcObj = getClassValue(source, nameKey);
                String srcValue = srcObj == null ? "" : srcObj.toString();
                if(tarMap.get(nameKey)==null || !tarMap.get(nameKey).equals(srcValue)){
                    result = false;
                    break;
                }
            } else {
                Object srcObj = getClassValue(source, nameKey);
                String srcValue = srcObj == null ? "" : srcObj.toString();
                Object tarObj = getClassValue(target, nameKey);
                String tarValue = tarObj == null ? "" : tarObj.toString();
                if (!srcValue.equals(tarValue)) {
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    /**
     * 根据字段名称取值
     * @param obj
     * @param fieldName
     * @return
     */
    public static Object getClassValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        try {
            Class beanClass = obj.getClass();
            Method[] ms = beanClass.getMethods();
            String methodName;
            for (int i = 0; i < ms.length; i++) {
                methodName = ms[i].getName();
                // 非get方法不取
                if (!methodName.startsWith("get")) {
                    continue;
                }
                if (methodName.equalsIgnoreCase(fieldName) || methodName.substring(3).equalsIgnoreCase(fieldName)
                        || ("SID".equalsIgnoreCase(fieldName) && "getId".equalsIgnoreCase(methodName))) {
                    Object objValue;
                    try {
                        objValue = ms[i].invoke(obj, new Object[]{});
                        if (objValue != null) {
                            return objValue;
                        }
                    } catch (Exception e) {
                        //ignore
                    }
                }
            }
        } catch (Exception e) {
            logger.info("取方法出错！", e);
        }
        return null;
    }

}
