package cn.com.duiba.wolf.cache;

import org.springframework.data.redis.cache.RedisCache;

import java.util.concurrent.TimeUnit;

/**
 *
 *memcached 迁移到redis时候为了防止缓存击穿，引入这个类。所有操作都转发给memcached和redis，该类仅供临时使用，过渡用
 * Created by wenqi.huang on 2017/1/14.
 */
@Deprecated
public class AdvancedCacheClientDelegate implements AdvancedCacheClient {

    private RedisCacheClient redisCacheCient;
    private AdvancedCacheClient memcachedClient;

    public AdvancedCacheClientDelegate(){
    }

    public AdvancedCacheClientDelegate(RedisCacheClient redisCacheCient, AdvancedCacheClient memcachedClient){
        this.redisCacheCient = redisCacheCient;
        this.memcachedClient = memcachedClient;
    }

    public RedisCacheClient getRedisCacheCient() {
        return redisCacheCient;
    }

    public void setRedisCacheCient(RedisCacheClient redisCacheCient) {
        this.redisCacheCient = redisCacheCient;
    }

    public AdvancedCacheClient getMemcachedClient() {
        return memcachedClient;
    }

    public void setMemcachedClient(AdvancedCacheClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public <T> T get(String key) {
        return memcachedClient.get(key);
    }

    public boolean set(String key, Object value, int exp, TimeUnit timeUnit) {
        redisCacheCient.set(key, value, exp, timeUnit);
        return memcachedClient.set(key, value, exp, timeUnit);
    }

    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        T t = memcachedClient.getWithCacheLoader(key, exp, timeUnit, isCacheNull, cacheLoader);
        if(isCacheNull){
            redisCacheCient.setWithNull(key, t, exp, timeUnit);
        }else if(t != null){
            redisCacheCient.set(key, t, exp, timeUnit);
        }
        return t;
    }

    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader) {
        return getWithCacheLoader(key,exp,timeUnit,false,cacheLoader);
    }

    public boolean remove(String key) {
        redisCacheCient.remove(key);
        return memcachedClient.remove(key);
    }
}
