package cn.com.duiba.wolf.netflix.feign;


import org.springframework.core.annotation.AliasFor;
import org.springframework.cloud.netflix.feign.FeignClient;

import java.lang.annotation.*;

/**
 * 增强版的FeignClient注解，只能注解在interface上；<br/>
 * 对于服务端，如果一个注解了@Controller/@RestController的类的对应的接口上有此注解，则会自动做这些工作：
 * 1.扫描所有AdvancedFeignClient接口中的方法，以方法名作为uri（会与类上的RequestMapping注解自动合并），由于是自动扫描，方法上不再需要RequestMapping注解，所以方法名不能重复，否则会抛异常，默认识别为POST接口，如果需要自定义uri和method，可以加上RequestMapping注解。
 *  对于参数的处理，则全部使用json序列化方式,参数上不应该存在RequestParam等注解，有的话也会忽略，详情请访问：http://cf.dui88.com
 * <br/>
 * 对于客户端，做类似处理。<br/>
 * 这个类可以标注在package-info.java上，对当前package及子package下的所有类都生效，这样可以在package-info.java中定义name，以避免重复定义.标注在包上时，目前只有name属性会起作用，name的寻找顺序为：类上的注解->当前包的注解->上级包（直到根）的注解
 *
 * <br/><br/>
 * Annotation for interfaces declaring that a REST client with that interface should be
 * created (e.g. for autowiring into another component). If ribbon is available it will be
 * used to load balance the backend requests, and the load balancer can be configured
 * using a <code>@RibbonClient</code> with the same name (i.e. value) as the feign client.
 *
 * @author Spencer Gibb
 * @author Venil Noronha
 */
@Target({ElementType.TYPE, ElementType.PACKAGE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@FeignClient
public @interface AdvancedFeignClient {

    /**
     * The name of the service with optional protocol prefix. Synonym for {@link #name()
     * name}. A name must be specified for all clients, whether or not a url is provided.
     * Can be specified as property key, eg: ${propertyKey}.
     */
//    @AliasFor("name")
    @AliasFor(annotation = FeignClient.class)
    String value() default "";

    /**
     * The service id with optional protocol prefix. Synonym for {@link #value() value}.
     */
//    @AliasFor("value")
    @AliasFor(annotation = FeignClient.class)
    String name() default "";

    /**
     * Sets the <code>@Qualifier</code> value for the feign client.
     */
    @AliasFor(annotation = FeignClient.class)
    String qualifier() default "";

    /**
     * An absolute URL or resolvable hostname (the protocol is optional).
     */
    @AliasFor(annotation = FeignClient.class)
    String url() default "";

    /**
     * Whether 404s should be decoded instead of throwing FeignExceptions
     */
    @AliasFor(annotation = FeignClient.class)
    boolean decode404() default false;

    /**
     * A custom <code>@Configuration</code> for the feign client. Can contain override
     * <code>@Bean</code> definition for the pieces that make up the client, for instance
     * {@link feign.codec.Decoder}, {@link feign.codec.Encoder}, {@link feign.Contract}.
     *
     * @see org.springframework.cloud.netflix.feign.FeignClientsConfiguration for the defaults
     */
    @AliasFor(annotation = FeignClient.class)
    Class<?>[] configuration() default {};

    /**
     * Fallback class for the specified Feign client interface. The fallback class must
     * implement the interface annotated by this annotation and be a valid spring bean.
     * <br/>
     * 指定的class会自动加入springbean，所以对应类上不需要加入@Component等注解
     */
    @AliasFor(annotation = FeignClient.class)
    Class<?> fallback() default void.class;

    /**
     * Define a fallback factory for the specified Feign client interface. The fallback
     * factory must produce instances of fallback classes that implement the interface
     * annotated by {@link AdvancedFeignClient}. The fallback factory must be a valid spring
     * bean.
     * <br/>
     * 指定的class会自动加入springbean，所以对应类上不需要加入@Component等注解
     *
     * @see feign.hystrix.FallbackFactory for details.
     */
    @AliasFor(annotation = FeignClient.class)
    Class<?> fallbackFactory() default void.class;

    /**
     * Path prefix to be used by all method-level mappings. Can be used with or without
     * <code>@RibbonClient</code>.
     */
    @AliasFor(annotation = FeignClient.class)
    String path() default "";

}
