package cn.com.duiba.wolf.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

/**
 * 并发工具类
 * Created by wenqi.huang on 16/6/2.
 */
public class ConcurrentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentUtils.class);

    private ConcurrentUtils() {
    }

    /**
     * 在线程池中运行任务并阻塞直到所有线程都完成
     *
     * @param runnables
     */
    public static void executeTasksBlocking(Executor executor, List<Runnable> runnables) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(runnables.size());

        for (final Runnable r : runnables) {
            executor.execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        r.run();
                    } finally {
                        latch.countDown();
                    }
                }
            });
        }

        try {
            latch.await();
        } catch (InterruptedException e) {
            throw e;
        }
    }

    /**
     * 在线程池中运行任务并阻塞直到所有线程都完成,callables的顺序和返回值的顺序一致
     *
     * @param callables
     * @return Callable的结果
     */
    public static <V> List<V> submitTasksBlocking(Executor executor, List<Callable<V>> callables) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(callables.size());
        //final BlockingQueue<V> queue = new LinkedBlockingQueue<V>();
        final ConcurrentMap<Integer, V> seq2valueMap = new ConcurrentHashMap<>();

        int i = 0;
        for (final Callable<V> r : callables) {
            final int j = i;
            i++;
            executor.execute(new Runnable() {

                @Override
                public void run() {
                    try {
                        V v = r.call();
                        //queue.add(v);
                        seq2valueMap.put(j, v);
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    } finally {
                        latch.countDown();
                    }
                }
            });
        }

        try {
            latch.await();
        } catch (InterruptedException e) {
            throw e;
        }
        List<V> ret = new ArrayList<>(i);//queue
        for(int k = 0;k<i;k++){
            ret.add(seq2valueMap.get(k));
        }

        return ret;
    }
}
