package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;

/**
 * Created by xuezhaoming on 16/6/1.<br/>
 * dubbo服务的接口服务
 */
@Activate(group = { Constants.PROVIDER }, order = -9001)//CatTransaction的order为9000，让MonitorFilter在cat之前
public class MonitorFilter implements Filter {

    static {
        InitOperation.init();
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        RpcContext context = RpcContext.getContext();
        boolean providerSide = context.isProviderSide();
        if (providerSide) {
            DBTimeProfile.start();
        }

        try {
            return invoker.invoke(invocation);
        } finally {
            if (providerSide) {
                StringBuilder methodName = new StringBuilder();
                methodName.append(invocation.getInvoker().getInterface().getSimpleName())
                        .append(".").append(invocation.getMethodName());
                Long requestId = (Long)RpcContext.getContext().get("request.id");
                if(requestId != null){
                    methodName.append("(reqId:").append(requestId).append(")");
                }
                DBTimeProfile.end(methodName.toString());
            }
        }

    }
}
