package cn.com.duiba.wolf.redis;

import org.springframework.data.redis.core.RedisTemplate;

import java.beans.PropertyEditorSupport;

/**
 * 这个类负责把RedisTemplate 转换成 RedisAtomicClient。
 *
 * spring会自动找到这个类（*Editor）,spring的Editor机制
 *
 * Created by wenqi.huang on 2017/1/14.
 */
public class RedisAtomicClientEditor extends PropertyEditorSupport {

    @Override
    public void setValue(Object value) {
        if (value instanceof RedisTemplate) {
            RedisAtomicClient redisAtomicClient = new RedisAtomicClient((RedisTemplate)value);
            super.setValue(redisAtomicClient);
        } else {
            throw new IllegalArgumentException("Editor supports only conversion of type " + RedisTemplate.class);
        }
    }
}
