package cn.com.duiba.wolf.spring.velocity;

import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/**
 * 一种velocity工具。
 * <br/>
 * 此工具会把注入的class中的静态变量收集起来,提供给vm页面使用
 * vm页面中使用类似$staticFieldTool["cn.com.duiba.dataobject.AppDO.Dcustom"]的方式来访问
 * @author wenqi.huang
 */
public class StaticFieldTool extends SafeConfig{
    public static final String INCLUDE_KEY = "include";
    public static final String STORE_DYNAMIC_KEY = "storeDynamicLookups";
    private static final Object NULL = new Object();
    protected Log log;
    protected HashMap storage = new HashMap();
    protected boolean storeDynamicLookups = true;

    public StaticFieldTool() {
        //do nothing
    }

    @Override
    protected void configure(ValueParser values) {
        this.log = (Log)values.getValue("log");
        String[] classnames = values.getStrings("include");
        if(classnames != null) {
            String[] arr = classnames;
            int len = classnames.length;

            for(int i = 0; i < len; ++i) {
                String classname = arr[i];
                if(this.in(classname) == null) {
                    throw new RuntimeException("Could not find " + classname + " in the classpath");
                }
            }
        }

        this.storeDynamicLookups = values.getBoolean("storeDynamicLookups", this.storeDynamicLookups);
    }

    public Object get(String name) {
        Object o = simpleGet(name);
        if(o != null){
            return o == NULL?null:o;
        }

        if(name.indexOf(46) > 0) {//46表示点号符.
            int lastDot = name.lastIndexOf(46);
            String classname = name.substring(0, lastDot);
            //String fieldname = name.substring(lastDot + 1, name.length());
            if(this.in(classname) == null) {
                throw new RuntimeException("Could not find " + classname + " in the classpath");
            }
            o = simpleGet(name);
            return o == NULL?null:o;
        }
        return o;
    }

    private Object simpleGet(String name){
        Object o = this.storage.get(name);
        if(o instanceof StaticFieldTool.MutableField) {
            Object ret = ((StaticFieldTool.MutableField)o).getValue();
            if(ret == null){
                return NULL;
            }else{
                return ret;
            }
        } else {
            return o;
        }
    }

    public StaticFieldTool.FieldToolSub in(String classname) {
        try {
            return this.in(ClassUtils.getClass(classname));
        } catch (ClassNotFoundException var3) {
            return null;
        }
    }

    public StaticFieldTool.FieldToolSub in(Object instance) {
        return instance == null?null:this.in(instance.getClass());
    }

    public StaticFieldTool.FieldToolSub in(Class clazz) {
        if(clazz == null) {
            return null;
        } else {
            Map results = this.inspect(clazz);
            if(this.storeDynamicLookups && !results.isEmpty()) {
                this.storage.putAll(results);
            }

            return new StaticFieldTool.FieldToolSub(results);
        }
    }

    protected Map<String, Object> inspect(Class clazz) {
        HashMap results = new HashMap();
        Field[] arr = clazz.getFields();
        int len = arr.length;

        for(int i = 0; i < len; ++i) {
            Field field = arr[i];
            int mod = field.getModifiers();
            if(Modifier.isStatic(mod) && Modifier.isPublic(mod)) {
                if(this.log != null && this.log.isDebugEnabled() && results.containsKey(field.getName())) {
                    this.log.debug("StaticFieldTool: " + field.getName() + " is being overridden by " + clazz.getName());
                }

                if(Modifier.isFinal(mod)) {
                    results.put(clazz.getName()+"."+field.getName(), retrieve(field, clazz, this.log));
                } else {
                    results.put(clazz.getName()+"."+field.getName(), new StaticFieldTool.MutableField(field, clazz, this.log));
                }
            }
        }

        return results;
    }

    protected static Object retrieve(Field field, Class clazz, Log log) {
        try {
            return field.get(clazz);
        } catch (IllegalAccessException var4) {
            if(log != null) {
                log.warn("IllegalAccessException while trying to access " + field.getName(), var4);
            }

            return null;
        }
    }

    public static class MutableField {
        private final Class clazz;
        private final Field field;
        private final Log log;

        public MutableField(Field f, Class c, Log l) {
            if(f != null && c != null) {
                this.field = f;
                this.clazz = c;
                this.log = l;
            } else {
                throw new NullPointerException("Both Class and Field must NOT be null");
            }
        }

        public Object getValue() {
            return StaticFieldTool.retrieve(this.field, this.clazz, this.log);
        }
    }

    public static class FieldToolSub {
        private final Map<String, Object> results;

        public FieldToolSub(Map<String, Object> results) {
            if(results == null) {
                throw new NullPointerException("Cannot create sub with null field results map");
            } else {
                this.results = results;
            }
        }

        public Object get(String name) {
            Object o = this.results.get(name);
            return o instanceof StaticFieldTool.MutableField?((StaticFieldTool.MutableField)o).getValue():o;
        }

        @Override
        public String toString() {
            return this.results.toString();
        }
    }
}
