/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.security.SecureRandom;
import java.util.UUID;
import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class UUIDUtils {
    public static String createUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String createCompressedUUID() {
        UUID uuid = UUID.randomUUID();
        return UUIDUtils.compressedUUID(uuid);
    }

    public static String createSecureUUID() {
        SecureRandom ranGen = new SecureRandom();
        byte[] bs = new byte[16];
        ranGen.nextBytes(bs);
        return Hex.encodeHexString((byte[])bs);
    }

    public static String createCompressedSecureUUID() {
        SecureRandom ranGen = new SecureRandom();
        byte[] bs = new byte[16];
        ranGen.nextBytes(bs);
        return Base64.encodeBase64URLSafeString((byte[])bs);
    }

    private static String compressedUUID(UUID uuid) {
        byte[] byUuid = new byte[16];
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        UUIDUtils.long2bytes(most, byUuid, 0);
        UUIDUtils.long2bytes(least, byUuid, 8);
        return Base64.encodeBase64URLSafeString((byte[])byUuid);
    }

    private static void long2bytes(long value, byte[] bytes, int offset) {
        for (int i = 7; i > -1; --i) {
            bytes[offset++] = (byte)(value >> 8 * i & 0xFFL);
        }
    }

    public static String uncompress(String compressedUuid) {
        if (compressedUuid.length() != 22) {
            throw new IllegalArgumentException("Invalid uuid!");
        }
        byte[] byUuid = Base64.decodeBase64((String)(compressedUuid + "=="));
        long most = UUIDUtils.bytes2long(byUuid, 0);
        long least = UUIDUtils.bytes2long(byUuid, 8);
        UUID uuid = new UUID(most, least);
        return uuid.toString().replaceAll("-", "");
    }

    private static long bytes2long(byte[] bytes, int offset) {
        long value = 0L;
        for (int i = 7; i > -1; --i) {
            value |= ((long)bytes[offset++] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static void main(String[] args) {
        String a = "1";
        String b = "fa1";
        System.out.println(ObjectSizeCalculator.getObjectSize((Object)a));
        System.out.println(ObjectSizeCalculator.getObjectSize((Object)b));
        Short s = Short.valueOf("1");
        System.out.println(ObjectSizeCalculator.getObjectSize((Object)s));
        System.out.println(ObjectSizeCalculator.getObjectSize((Object)1));
        System.out.println(ObjectSizeCalculator.getObjectSize((Object)1L));
    }
}

