/* 
 * @(#)MapUtils.java    Created on 2013年6月25日
 * Copyright (c) 2013 ZDSoft Networks, Inc. All rights reserved.
 * $Id$
 */
package cn.com.duiba.wolf.utils;


/**
 * 经纬度工具类
 */
public class LatLngUtils {

    private LatLngUtils() {
    }

    /**
     * 根据球面计算距离
     *
     * @param lat1
     *            30.222222
     * @param lng1
     *            120.120000
     * @param lat2
     *            30.222222
     * @param lng2
     *            120.120000
     * @return 两个经纬度之间的距离,单位：米
     */
    public static double getDistanceByLngLat(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = rad(lat1);
        double radLat2 = rad(lat2);
        double a = radLat1 - radLat2;
        double b = rad(lng1) - rad(lng2);
        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2) + Math.cos(radLat1) * Math.cos(radLat2)
                * Math.pow(Math.sin(b / 2), 2)));
        s = s * 6378137.0;// 地球半径
        s = Math.round(s * 10000) / 10000;
        return s;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static void main(String[] args) {
        System.out.println(getDistanceByLngLat(30.278428, 120.115091,30.279045,  120.125133));
        System.out.println(getDistanceByLngLat(30.278428,120.115091,  30.278428,120.115291));
    }
}
