/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import cn.com.duiba.wolf.utils.NumberUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;

public class ClassUtils {
    private static final String CLASS_POSTFIX = ".class";

    private ClassUtils() {
    }

    public static List<Class<?>> getClassList(String pkgName, boolean isRecursive, Class<? extends Annotation> annotation) {
        ArrayList classList = new ArrayList();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String strFile = StringUtils.replace((String)pkgName, (String)".", (String)"/");
            Enumeration<URL> urls = loader.getResources(strFile);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                String pkgPath = url.getPath();
                if ("file".equals(protocol)) {
                    ClassUtils.findClassName(classList, pkgName, pkgPath, isRecursive, annotation);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                ClassUtils.findClassName(classList, pkgName, url, isRecursive, annotation);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return classList;
    }

    private static void findClassName(List<Class<?>> clazzList, String pkgName, String pkgPath, boolean isRecursive, Class<? extends Annotation> annotation) {
        File[] files;
        if (clazzList == null) {
            return;
        }
        for (File f : files = ClassUtils.filterClassFiles(pkgPath)) {
            String fileName = f.getName();
            if (f.isFile()) {
                String clazzName = ClassUtils.getClassName(pkgName, fileName);
                ClassUtils.addClassName(clazzList, clazzName, annotation);
                continue;
            }
            if (!isRecursive) continue;
            String subPkgName = pkgName + "." + fileName;
            String subPkgPath = pkgPath + "/" + fileName;
            ClassUtils.findClassName(clazzList, subPkgName, subPkgPath, true, annotation);
        }
    }

    private static void findClassName(List<Class<?>> clazzList, String pkgName, URL url, boolean isRecursive, Class<? extends Annotation> annotation) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            String clazzName = jarEntryName.replace("/", ".");
            int endIndex = clazzName.lastIndexOf(46);
            String prefix = null;
            if (endIndex > 0) {
                String prefixName = clazzName.substring(0, endIndex);
                if (clazzName.endsWith(CLASS_POSTFIX)) {
                    clazzName = prefixName;
                }
                if ((endIndex = prefixName.lastIndexOf(46)) > 0) {
                    prefix = prefixName.substring(0, endIndex);
                }
            }
            if (prefix == null || !jarEntryName.endsWith(CLASS_POSTFIX) || !prefix.equals(pkgName) && (!isRecursive || !prefix.startsWith(pkgName))) continue;
            ClassUtils.addClassName(clazzList, clazzName, annotation);
        }
    }

    private static File[] filterClassFiles(String pkgPath) {
        if (pkgPath == null) {
            return new File[0];
        }
        return new File(pkgPath).listFiles(file -> file.isFile() && file.getName().endsWith(CLASS_POSTFIX) || file.isDirectory());
    }

    private static String getClassName(String pkgName, String fileName) {
        int endIndex = fileName.lastIndexOf(46);
        String clazz = null;
        if (endIndex >= 0) {
            clazz = fileName.substring(0, endIndex);
        }
        String clazzName = null;
        if (clazz != null) {
            clazzName = pkgName + "." + clazz;
        }
        return clazzName;
    }

    private static void addClassName(List<Class<?>> clazzList, String clazzName, Class<? extends Annotation> annotation) {
        if (clazzList != null && clazzName != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (clazz != null && (annotation == null || clazz.isAnnotationPresent(annotation))) {
                clazzList.add(clazz);
            }
        }
    }

    public static void checkSerializable(String ... packageNames) {
        for (String pkgName : packageNames) {
            List<Class<?>> classes = ClassUtils.getClassList(pkgName, true, null);
            for (Class<?> clazz : classes) {
                if (ClassUtils.shouldSkip(clazz)) continue;
                if (!Serializable.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("class: [" + clazz.getName() + "] must implements Serializable");
                }
                try {
                    clazz.getDeclaredConstructor(null);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("class: [" + clazz.getName() + "] must have default Constructor");
                }
            }
        }
    }

    private static boolean shouldSkip(Class<?> clazz) {
        String csn = clazz.getName();
        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) {
            return true;
        }
        if (csn.contains("$") && NumberUtils.isNumeric(csn.substring(csn.lastIndexOf(36) + 1))) {
            return true;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz.getName().endsWith("Builder");
    }
}

