package cn.com.duiba.wolf.degrade;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;

/**
 * Created by xuezhaoming on 16/6/7.
 */
public abstract class DegradeTemplate<T> {

    private Cache<Object, Lock> build = Caffeine.newBuilder().expireAfterWrite(1, TimeUnit.HOURS).build();

    public T execute() {

        T result = null;
        try {
            result = doNormal();

        } catch (Exception e) {

            Lock lock = null;
            try {
                lock = build.get(getKey(), o -> new ReentrantLock());

                if (lock.tryLock()) {
                    result = doError();
                }
            } finally {
                if(lock != null) {
                    lock.unlock();
                }
            }

        }

        return result;
    }

    /**
     * 获取对象锁
     * 
     * @return
     */
    public abstract Object getKey();

    /**
     * 正常业务逻辑处理
     * 
     * @return
     */
    public abstract T doNormal();

    /**
     * 异常错误处理
     * 
     * @return
     */
    public abstract T doError();

}
