package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;

/**
 * 给dubbo服务附加DBTimeProfile耗时信息
 */
@Activate(group = { CommonConstants.PROVIDER }, order = -9001)//CatTransaction的order为9000，让MonitorFilter在cat之前
public class MonitorFilter implements Filter {

    static {
        InitOperation.init();
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) {

        RpcContext context = RpcContext.getContext();
        boolean providerSide = context.isProviderSide();
        if (providerSide) {
            DBTimeProfile.start();
        }

        try {
            return invoker.invoke(invocation);
        } finally {
            if (providerSide) {
                StringBuilder methodName = new StringBuilder();
                methodName.append(invocation.getInvoker().getInterface().getSimpleName())
                        .append(".").append(invocation.getMethodName());
                Long requestId = (Long)RpcContext.getContext().get("request.id");
                if(requestId != null){
                    methodName.append("(reqId:").append(requestId).append(")");
                }
                DBTimeProfile.end(methodName.toString());
            }
        }

    }
}
