package cn.com.duiba.wolf.entity;

import java.io.Serializable;

/**
 * 分页请求实体
 */
public class PageRequest implements Serializable {

    private static final long serialVersionUID = 8405729624296314386L;

    /**
     * 当前页码。从1开始计数
     */
    private int pageNo;

    /**
     * 每页记录数
     */
    private int pageSize;

    public PageRequest() {
    }

    public PageRequest(int pageNo, int pageSize) {
        this.setPageNo(pageNo);
        this.setPageSize(pageSize);
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        if (pageNo < 1) {
            throw new IllegalArgumentException("pageNo不能小于1");
        }
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize不能小于1");
        }
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return (this.pageNo - 1) * this.pageSize;
    }

}
