/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.DubboResult;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.io.UnsafeStringWriter;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;

@Activate(group={"provider"}, order=-9001)
public class RuntimeExceptionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);
    private static final Set<Class<? extends RuntimeException>> serviceInternalRuntimeExceptions = new HashSet<Class<? extends RuntimeException>>();

    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result = invoker.invoke(invocation);
        if (result.hasException() && GenericService.class != invoker.getInterface()) {
            try {
                Throwable exception = result.getException();
                if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                    return result;
                }
                if (exception instanceof RpcException) {
                    return result;
                }
                try {
                    Class<?>[] exceptionClasses;
                    Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                    for (Class<?> exceptionClass : exceptionClasses = method.getExceptionTypes()) {
                        if (!exception.getClass().equals(exceptionClass)) continue;
                        return result;
                    }
                    Class<?> clazz = method.getReturnType();
                    if (clazz.equals(Void.TYPE)) {
                        return result;
                    }
                    if (clazz.equals(DubboResult.class)) {
                        this.logException(invocation.getArguments(), exception);
                        String exceptionMsg = exception.getMessage();
                        if (exception.getCause() == null && exception.getClass().equals(RuntimeException.class) && !StringUtils.isEmpty((String)exceptionMsg)) {
                            return new AppResponse(DubboResult.failResult(exception.getMessage()));
                        }
                        if (serviceInternalRuntimeExceptions.contains(exception.getClass())) {
                            DubboResult dubboResult = DubboResult.failResult("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
                            dubboResult.setReturnCode("0102");
                            return new AppResponse(dubboResult);
                        }
                        return new AppResponse(DubboResult.failResult(exception.getMessage()));
                    }
                    return result;
                }
                catch (NoSuchMethodException e) {
                    return result;
                }
            }
            catch (Exception e) {
                return result;
            }
        }
        return result;
    }

    private void logException(Object[] arguments, Throwable exception) {
        StringBuilder message = new StringBuilder(exception.getMessage());
        message.append(" params : ");
        String argumentsStr = Arrays.toString(arguments);
        int maxArgumentsStrLen = 300;
        if (argumentsStr != null && argumentsStr.length() > maxArgumentsStrLen) {
            argumentsStr = argumentsStr.substring(0, maxArgumentsStrLen);
            message.append(argumentsStr).append(" ... (").append(argumentsStr.length() - maxArgumentsStrLen).append(" more characters).");
        } else {
            message.append(argumentsStr);
        }
        log.error(message.toString(), exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toShortString(Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        try (PrintWriter p = new PrintWriter((Writer)w);){
            this.printStackTrace(e, p, true);
            String string = w.toString();
            return string;
        }
    }

    private void printStackTrace(Throwable e, PrintWriter p, boolean isTop) {
        if (e != null) {
            if (isTop) {
                p.println(e);
            } else {
                p.println("Caused by: " + e);
            }
            StackTraceElement[] trace = e.getStackTrace();
            int i = 0;
            int lastPrintedLineNumber = 0;
            for (StackTraceElement traceElement : trace) {
                if (i < 2 || traceElement.getClassName().startsWith("cn.com.duiba")) {
                    if (lastPrintedLineNumber < i - 1) {
                        p.println("\t...");
                    }
                    p.println("\tat " + traceElement);
                    lastPrintedLineNumber = i;
                }
                ++i;
            }
            this.printStackTrace(e.getCause(), p, false);
        }
    }

    static {
        serviceInternalRuntimeExceptions.add(NestedRuntimeException.class);
    }
}

