/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.entity;

import java.io.Serializable;

public class JsonResult<T>
implements Serializable {
    private static final long serialVersionUID = -5466658167998456598L;
    private static final String DEFAULT_FAIL_CODE = "-1";
    private static final String DEFAULT_SUCCESS_CODE = "0";
    private boolean success;
    private String desc;
    private T data;
    private String code;
    private long timestamp;

    private JsonResult() {
    }

    public static <T> JsonResult<T> fail(String code, String desc) {
        JsonResult<T> result = new JsonResult<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    public static <T> JsonResult<T> fail(String desc) {
        return JsonResult.fail(DEFAULT_FAIL_CODE, desc);
    }

    public static <T> JsonResult<T> fail(String code, String desc, T data) {
        JsonResult<T> result = new JsonResult<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        result.setData(data);
        return result;
    }

    public static <T> JsonResult<T> fail(String desc, T data) {
        return JsonResult.fail(DEFAULT_FAIL_CODE, desc, data);
    }

    public static <T> JsonResult<T> success(String code, T data) {
        JsonResult<T> result = new JsonResult<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setDesc("OK");
        return result;
    }

    public static <T> JsonResult<T> success(T data) {
        return JsonResult.success(DEFAULT_SUCCESS_CODE, data);
    }

    public static <T> JsonResult<T> success() {
        return JsonResult.success(DEFAULT_SUCCESS_CODE, null);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }
}

