/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf.timeprofile;

import cn.com.duiba.wolf.dubbo.InitOperation;
import cn.com.duiba.wolf.log.DegradeLogger;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTimeProfile {
    private static final Logger log = DegradeLogger.wrap(LoggerFactory.getLogger(DBTimeProfile.class));
    private static final ThreadLocal<LinkedList<TimeProfileElement>> logs = new ThreadLocal();
    private static final ThreadLocal<TimeProfileElement> currentElement = new ThreadLocal();
    private static final ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private static final ThreadLocal<Integer> currentThreshold = new ThreadLocal();
    private static volatile int threshold = 100;
    private static final String timeout = "DBTimeProfile timeout ";

    private DBTimeProfile() {
    }

    private static void enter() {
        DBTimeProfile.enter("");
    }

    public static void enter(String tag) {
        if (logs.get() == null) {
            return;
        }
        TimeProfileElement cur = currentElement.get();
        TimeProfileElement t = new TimeProfileElement();
        t.logEnterTime();
        t.setTag(tag);
        t.parent = cur;
        t.setDeep(cur == null ? 0 : cur.getDeep() + 1);
        currentElement.set(t);
        logs.get().add(t);
    }

    public static void release() {
        LinkedList<TimeProfileElement> s1 = logs.get();
        TimeProfileElement cur = currentElement.get();
        if (s1 == null || cur == null) {
            return;
        }
        if (s1.size() <= 1) {
            log.warn("release failed,will stop this timeProfile, enter/release \u5fc5\u987b\u6210\u5bf9\u51fa\u73b0", (Throwable)new IllegalStateException());
            DBTimeProfile.clear();
            return;
        }
        cur.logReleaseTime();
        currentElement.set(cur.parent);
    }

    public static void start() {
        logs.set(new LinkedList());
        DBTimeProfile.enter();
    }

    public static void end() {
        DBTimeProfile.end("undefined");
    }

    public static void end(String methodName) {
        TimeProfileElement cur = currentElement.get();
        if (cur == null) {
            return;
        }
        if (cur.parent != null) {
            log.warn("timeProfile methodName:{} failed, enter/release \u5fc5\u987b\u6210\u5bf9\u51fa\u73b0", (Object)methodName);
            DBTimeProfile.clear();
            return;
        }
        cur.logReleaseTime();
        long timeConsume = cur.getCostTimeMillis();
        Integer threshold = currentThreshold.get();
        if (threshold == null) {
            threshold = DBTimeProfile.threshold;
        }
        if (cur.getCostTimeMillis() > (long)threshold.intValue()) {
            StringBuilder sb = new StringBuilder();
            if (request.get() != null) {
                String url = RequestTool.getRequestUrl(request.get());
                sb.append(timeout).append(timeConsume).append("ms >").append(threshold).append("ms, url=").append(url);
            } else {
                sb.append(timeout).append(timeConsume).append("ms > methodName:").append(methodName);
            }
            ArrayList list = new ArrayList(logs.get());
            for (TimeProfileElement s : list) {
                sb.append("\r\n\t");
                for (int i = 0; i < s.getDeep(); ++i) {
                    sb.append("-");
                }
                Long consume = s.getCostTimeMillis();
                sb.append(consume * 100L / timeConsume).append("%");
                sb.append("  ").append(consume).append("ms");
                if (s.getTag() == null) continue;
                sb.append("  ").append(s.getTag());
            }
            log.warn("{}", (Object)sb);
        }
        DBTimeProfile.clear();
    }

    private static void clear() {
        request.set(null);
        currentElement.set(null);
        logs.set(null);
        currentThreshold.set(null);
    }

    public static void setThreshold(int threshold) {
        DBTimeProfile.threshold = threshold;
    }

    public static void setCurrentThreshold(int threshold) {
        currentThreshold.set(threshold);
    }

    public static Integer getCurrentThreshold() {
        return currentThreshold.get();
    }

    private static String dump() {
        if (logs.get() == null) {
            return null;
        }
        TimeProfileElement cur = currentElement.get();
        cur.logReleaseTime();
        Long timeconsume = 0L;
        for (TimeProfileElement s : logs.get()) {
            if (s.deep != 0) continue;
            timeconsume = timeconsume + s.getCostTimeMillis();
        }
        if (timeconsume < 0L) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(timeout).append(timeconsume).append("ms ");
        ArrayList list = new ArrayList(logs.get());
        Collections.reverse(list);
        for (TimeProfileElement s : list) {
            Long consume = s.getCostTimeMillis();
            if (consume == 0L) continue;
            sb.append("\r\n\t");
            for (int i = 0; i < s.getDeep(); ++i) {
                sb.append("  ");
            }
            sb.append("-");
            sb.append(consume * 100L / timeconsume).append("%");
            sb.append("  ").append(consume).append("ms");
            if (s.getTag() == null) continue;
            sb.append("  ").append(s.getTag());
        }
        DBTimeProfile.clear();
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (int j = 0; j < 2; ++j) {
            DBTimeProfile.setCurrentThreshold(0);
            DBTimeProfile.start();
            for (int i = 0; i < 5; ++i) {
                try {
                    DBTimeProfile.enter("in" + i);
                    Thread.sleep(1L);
                    try {
                        DBTimeProfile.enter("in1" + i);
                        Thread.sleep(1L);
                    }
                    finally {
                        DBTimeProfile.release();
                    }
                    try {
                        DBTimeProfile.enter("in2" + i);
                        Thread.sleep(1L);
                        continue;
                    }
                    finally {
                        DBTimeProfile.release();
                    }
                }
                finally {
                    DBTimeProfile.release();
                }
            }
            DBTimeProfile.end("fuck!");
        }
    }

    static {
        InitOperation.init();
    }

    private static class TimeProfileElement {
        private static final long BASE_TIME = System.currentTimeMillis();
        private int timeMillis;
        private int deep;
        private String tag;
        private TimeProfileElement parent;

        private TimeProfileElement() {
        }

        void logEnterTime() {
            this.timeMillis = (int)(System.currentTimeMillis() - BASE_TIME);
        }

        void logReleaseTime() {
            this.timeMillis = (int)(System.currentTimeMillis() - BASE_TIME - (long)this.timeMillis);
        }

        long getCostTimeMillis() {
            return this.timeMillis;
        }

        int getDeep() {
            return this.deep;
        }

        void setDeep(int deep) {
            this.deep = deep;
        }

        String getTag() {
            return this.tag;
        }

        void setTag(String tag) {
            this.tag = tag;
        }
    }
}

