/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;

public class NumberUtils {
    public static int parseInt(String str, int defaultValue) {
        int value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static float parseFloat(String str, float defaultValue) {
        float value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Float.parseFloat(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static long parseLong(String str, long defaultValue) {
        long value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Long.parseLong(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static double parseDouble(String str, double defaultValue) {
        double value;
        if (StringUtils.isEmpty((String)str)) {
            return defaultValue;
        }
        try {
            value = Double.parseDouble(str.trim());
        }
        catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static Long add(Long val1, Long val2) {
        Long tmpval1 = val1 != null ? val1 : 0L;
        Long tmpval2 = val2 != null ? val2 : 0L;
        return tmpval1 + tmpval2;
    }

    public static Integer add(Integer val1, Integer val2) {
        Integer tmpval1 = val1 != null ? val1 : 0;
        Integer tmpval2 = val2 != null ? val2 : 0;
        return tmpval1 + tmpval2;
    }

    public static Double add(Double val1, Double val2) {
        Double tmpval1 = val1 != null ? val1 : 0.0;
        Double tmpval2 = val2 != null ? val2 : 0.0;
        return tmpval1 + tmpval2;
    }

    public static String numberFormat(double f, int fractionDigits) {
        NumberFormat nf1 = NumberFormat.getInstance(Locale.CHINA);
        nf1.setMaximumFractionDigits(fractionDigits);
        nf1.setGroupingUsed(false);
        return nf1.format(f);
    }

    public static String numberFormat(float n, int fractionDigits) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(fractionDigits);
        return nf.format(n);
    }

    public static String percentFormat(double d) {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getPercentInstance();
        nf.applyPattern("##.##%");
        return nf.format(d);
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*\\.?[0-9]+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String encodeLong2ShortBase32String(long l) {
        Base32 b = new Base32();
        return b.encodeToString(NumberUtils.longToBytes(l)).replaceAll("=", "");
    }

    public static long decodeShortBase32String2Long(String s) {
        Base32 b = new Base32();
        byte[] bs = b.decode(s);
        if (bs.length < 8) {
            byte[] nbs = new byte[8];
            int j = 0;
            for (int i = 8 - bs.length; i < 8; ++i) {
                nbs[i] = bs[j++];
            }
            bs = nbs;
        }
        return NumberUtils.bytesToLong(bs);
    }

    private static byte[] longToBytes(long l) {
        int start = 0;
        byte[] b = new byte[8];
        b[0] = (byte)(l >>> 56);
        if (b[0] == 0) {
            ++start;
        }
        b[1] = (byte)(l >>> 48);
        if (b[1] == 0 && start == 1) {
            ++start;
        }
        b[2] = (byte)(l >>> 40);
        if (b[2] == 0 && start == 2) {
            ++start;
        }
        b[3] = (byte)(l >>> 32);
        if (b[3] == 0 && start == 3) {
            ++start;
        }
        b[4] = (byte)(l >>> 24);
        if (b[4] == 0 && start == 4) {
            ++start;
        }
        b[5] = (byte)(l >>> 16);
        if (b[5] == 0 && start == 5) {
            ++start;
        }
        b[6] = (byte)(l >>> 8);
        b[7] = (byte)l;
        if (start > 0) {
            return Arrays.copyOfRange(b, start, 8);
        }
        return b;
    }

    private static long bytesToLong(byte[] b) {
        return Byte.toUnsignedLong(b[0]) << 56 | Byte.toUnsignedLong(b[1]) << 48 | Byte.toUnsignedLong(b[2]) << 40 | Byte.toUnsignedLong(b[3]) << 32 | Byte.toUnsignedLong(b[4]) << 24 | Byte.toUnsignedLong(b[5]) << 16 | Byte.toUnsignedLong(b[6]) << 8 | Byte.toUnsignedLong(b[7]);
    }
}

