package cn.com.duiba.wooden.kite.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AuditOperateEnum.java , v 0.1 2020-03-20 1:44 下午 ZhouFeng Exp $
 */
@AllArgsConstructor
@Getter
public enum AuditOperateEnum {

    /**
     * 通过
     */
    PASS(1),

    /**
     * 拒绝
     */
    REJECT(0),

    ;

    private int code;
    private static final Map<Integer, AuditOperateEnum> CACHE =
            Arrays.stream(AuditOperateEnum.values()).collect(Collectors.toMap(AuditOperateEnum::getCode,
                    Function.identity()));

    public static AuditOperateEnum of(int code) {
        return CACHE.get(code);
    }

}
