/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wooden.kite.service.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum WorkflowStatusEnum {
    INITIAL(1),
    PRE_CHECK_PASS(2),
    CHECK_PENDING(3),
    PASS(4),
    REJECT(5),
    FINISH(6),
    CANCLE(7),
    SUCCESS(8),
    FAIL(9),
    BUILDING(10),
    NONE(11);

    private int code;
    private static Map<Integer, WorkflowStatusEnum> CACHE;

    public static WorkflowStatusEnum of(int code) {
        return CACHE.get(code);
    }

    private WorkflowStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    static {
        CACHE = Arrays.stream(WorkflowStatusEnum.values()).collect(Collectors.toMap(WorkflowStatusEnum::getCode, Function.identity()));
    }
}

