package cn.com.duiba.wooden.kite.service.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 工单简要信息
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WorkflowInfoDto.java , v 0.1 2020-03-24 10:15 上午 ZhouFeng Exp $
 */
@Data
public class WorkflowInfoDto implements Serializable {
    private static final long serialVersionUID = -2633221393671667966L;

    private Long id;

    /**
     * 创建用户id
     */
    private Long createUserId;

    /**
     * 发起人身份 1：开发 2：运营
     */
    private Integer initiator;
    /**
     * 创建用户姓名
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 工单状态
     *
     * @see cn.com.duiba.wooden.kite.service.api.enums.WorkflowStatusEnum
     */
    private Integer workflowStatus;

    /**
     * 项目配置发布状态
     */
    private Integer updateStatus;

    /**
     * 项目代码发布状态
     */
    private Integer installStatus;


    /**
     * 备注
     */
    private String remarks;

    /**
     * 发布类型: 1默认  2 问题修复 3 需求迭代
     */
    private Integer publishType;
}
