package cn.com.duiba.wooden.kite.service.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 星速台项目钉钉告警对象/告警消息接受对象群体类型
 *
 * @author fxr
 * @date 2020-6-8
 */
public enum AlarmMsgReceiverTypeEnum {

    /**
     * 开发
     */
    DEVELOPER(1, "开发", "developers"),
    /**
     * 测试
     */
    TESTER(2, "测试", "testers"),
    /**
     * 运营
     */
    OPERATOR(3, "运营", "operators");

    /**
     * code
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    /**
     * 对应星速台配置中，参与人员属性key
     */
    private String projectJoinerKey;

    AlarmMsgReceiverTypeEnum(Integer code, String desc, String projectJoinerKey) {
        this.code = code;
        this.desc = desc;
        this.projectJoinerKey = projectJoinerKey;
    }

    private static final Map<Integer, AlarmMsgReceiverTypeEnum> CACHE = Arrays.stream(AlarmMsgReceiverTypeEnum.values())
            .collect(Collectors.toMap(AlarmMsgReceiverTypeEnum::getCode, Function.identity()));

    public static AlarmMsgReceiverTypeEnum of(int code) {
        return CACHE.get(code);
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getProjectJoinerKey() {
        return projectJoinerKey;
    }

    public AlarmMsgReceiverTypeEnum setProjectJoinerKey(String projectJoinerKey) {
        this.projectJoinerKey = projectJoinerKey;
        return this;
    }
}
