package cn.com.duiba.wooden.kite.service.api.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author czw
 */
@Data
public class WorkGrayWhiteListDto implements Serializable {
    /**
     * 项目名称
     */
    @NotNull
    private String projectName;
    /**
     * 项目ID
     */
    @NotNull
    private String projectId;
    /**
     * APPId
     */
    @NotNull
    private String appId;

    /**
     * 1 兑吧运营申请
     * 2 开发者申请
     */
    private Integer applyType;

    /**
     * 1 新增
     * 2 删除
     */
    private Integer addOrDelete;

    /**
     * 灰度用户白名单
     */
    private List<String> uids;
    /**
     * 备注信息
     */
    private String remark;
    /**
     * 申请人
     */
    private Long createUserId;
    /**
     * 申请人姓名
     */
    private String createUserName;
    /**
     * 审核人员
     */
    private List<Long> checkUserIds;
    /**
     * app来源:
     * projectx
     * A
     * B
     */
    private String fromApp;

    /**
     * 业务id
     */
    private String commonId;
}
