package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * `merchant`
 */
@Data
public class Merchant implements Serializable {
    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("商户名称")
    private String merchantName;

    @ApiModelProperty("商户别名（代号）")
    private String merchantNickname;

    @ApiModelProperty("剩余合同数量")
    private Integer remainContract;

    @ApiModelProperty("总共合同数量")
    private Integer totalContract;

    @ApiModelProperty("过期时间")
    private Date expireDate;

    @ApiModelProperty("状态/0-正常，1-停用")
    private Byte merchantStatus;

    @ApiModelProperty("签约主体个数")
    private Integer signEntityCount;

    @ApiModelProperty("商户主管理员UserId")
    private Long adminUserId;

    @ApiModelProperty("主管理员账号")
    private String adminAccount;
}