package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;

/**
 * `order`
 */
@Data
public class Order implements Serializable {
    @ApiModelProperty("订单ID")
    private Long orderId;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("订单创建人")
    private Long createUserId;

    @ApiModelProperty("自定义订单编号")
    private String orderNo;

    @ApiModelProperty("订单种类数目")
    private Integer itemCount;

    @ApiModelProperty("货物数量，sum(item*个数)")
    private Integer goodsCount;

    @ApiModelProperty("合同编号")
    private Long contractId;

    @ApiModelProperty("订单原价")
    private BigDecimal originPrice;

    @ApiModelProperty("优惠的价格")
    private BigDecimal reducePrice;

    @ApiModelProperty("实际价格")
    private BigDecimal price;

    @ApiModelProperty("订单状态,0-草稿，1-已发送，2-已完成，3-作废")
    private Byte orderStatus;
}