package cn.com.duiba.youqian.center.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author tengtuox
 * @date 2019/12/30
 * @description 默认角色（用于初始化）
 */
@Getter
public enum EnumRole {

    ADMIN("管理员", EnumMenu.merchantMenuIdList()),
    SALESMAN("销售", Arrays.asList(EnumMenu.SALE.getMenuId(),
            EnumMenu.ORDER_CONTRACT.getMenuId(),
            EnumMenu.GOODS.getMenuId(),
            EnumMenu.CUSTOMER.getMenuId())),
    ORG_ADMIN("部门经理", Arrays.asList(EnumMenu.SALE.getMenuId(),
            EnumMenu.ORDER_CONTRACT.getMenuId(),
            EnumMenu.GOODS.getMenuId(),
            EnumMenu.CUSTOMER.getMenuId())),
    ;

    private String roleName;

    private List<Integer> menuList;

    EnumRole(String roleName, List<Integer> menuList) {
        this.roleName = roleName;
        this.menuList = menuList;
    }
}
