package cn.com.duiba.youqian.center.api.exception;

import lombok.Getter;

/**
 * @author tengtuox
 * @date 2019/12/27
 * @description: 错误码
 */
@Getter
public enum StandardCode {

    SUCCESS(0, "success"),
    UNKNOWN_ERROR(500, "系统繁忙"),
    PARAM_ERROR(700, "参数错误"),


    // User错误10开头
    USER_NOT_EXISTS(100001, "用户不存在"),

    // Merchant 11开头
    Merchant_NOT_EXISTS(110001, "商户不存在"),

    // ...
    ;

    private Integer code;

    private String strCode;

    private String description;

    StandardCode(Integer code, String description) {
        this.code = code;
        this.strCode = String.valueOf(code);
        this.description = description;
    }
}
