/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.youqian.center.api.util;

import cn.com.duiba.youqian.center.api.enums.HttpMethodEnum;
import cn.com.duiba.youqian.center.api.enums.MethodEnum;
import cn.com.duiba.youqian.center.api.util.HttpClientUtil;
import cn.com.duiba.youqian.center.api.util.RSAUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSQUtil {
    private static final Logger log = LoggerFactory.getLogger(SSQUtil.class);
    private String param;
    private String developerId;
    private String privateKey;
    private String urlSignParams = "?developerId=%s&rtick=%s&signType=rsa&sign=%s";
    private String serverHost;

    private String handleReq(String method, String url, JSONObject paramData) {
        this.setParam(paramData.toJSONString());
        String host = this.serverHost;
        String rtick = RSAUtil.getRtick();
        String paramsSign = RSAUtil.calcRsaSign(this.developerId, this.privateKey, host, url, rtick, null, paramData.toJSONString());
        String urlParams = String.format(this.urlSignParams, this.developerId, rtick, paramsSign);
        String responseBody = null;
        if (method.equals(HttpMethodEnum.get.name())) {
            byte[] bytes = HttpClientUtil.sendHttpGet(host, url, urlParams);
            try {
                responseBody = new String(bytes, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("change exception:[]", (Throwable)e);
                responseBody = null;
            }
        } else {
            responseBody = HttpClientUtil.sendHttpPost(host, url, urlParams, paramData.toJSONString());
        }
        return responseBody;
    }

    public String userReg(String account, String name, String mobile, String idCard) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("account", (Object)account);
        requestBody.put("name", (Object)name);
        requestBody.put("userType", (Object)"1");
        if (StringUtils.isNotEmpty((String)mobile)) {
            requestBody.put("mobile", (Object)mobile);
        }
        JSONObject credential = new JSONObject();
        credential.put("identity", (Object)idCard);
        credential.put("identityType", (Object)"0");
        if (StringUtils.isNotEmpty((String)mobile)) {
            credential.put("contactMobile", (Object)mobile);
        }
        requestBody.put("credential", (Object)credential);
        requestBody.put("applyCert", (Object)"1");
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.REGISTER.getUrl(), requestBody);
        return resData;
    }

    public String scanCard(String frontImg, String backImg) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("identityImage", (Object)frontImg);
        requestBody.put("identityBackImage", (Object)backImg);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CREDENTIAL_VERIFY_OCR_ID_CARD.getUrl(), requestBody);
        return resData;
    }

    public String getCert(String account) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("account", (Object)account);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CERT.getUrl(), requestBody);
        return resData;
    }

    public String asyApplyStatus(String account, String taskId) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("account", (Object)account);
        requestBody.put("taskId", (Object)taskId);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.ASYNC_APPLY_CERT.getUrl(), requestBody);
        return resData;
    }

    public String create(int pages, String account, String pdfName, String fmd5, String fdata, String title, String expireTime) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("account", (Object)account);
        requestBody.put("fmd5", (Object)fmd5);
        requestBody.put("ftype", (Object)"pdf");
        requestBody.put("fname", (Object)pdfName);
        requestBody.put("fpages", (Object)String.valueOf(pages));
        requestBody.put("fdata", (Object)fdata);
        requestBody.put("title", (Object)title);
        requestBody.put("expireTime", (Object)expireTime);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.STORAGE_CONTRACT_UPLOAD.getUrl(), requestBody);
        return resData;
    }

    public String send(String orderId, String account, String concertId, String x, String y, String pageNum, String mobile) {
        JSONObject send = new JSONObject();
        send.put("contractId", (Object)concertId);
        send.put("signer", (Object)account);
        send.put("dpi", (Object)"120");
        JSONArray array = new JSONArray();
        JSONObject position = new JSONObject();
        position.put("pageNum", (Object)pageNum);
        position.put("x", (Object)x);
        position.put("y", (Object)y);
        array.add((Object)position);
        send.put("signaturePositions", (Object)array);
        send.put("isAllowChangeSignaturePosition", (Object)"0");
        send.put("returnUrl", (Object)("http://10.10.93.146:17796/test/success?orderId=" + orderId));
        send.put("pushUrl", (Object)"http://l2591450m0.qicp.vip/notify/ssq");
        send.put("isDrawSignatureImage", (Object)"2");
        send.put("signatureImageName", (Object)"default");
        send.put("sid", (Object)orderId);
        send.put("readAll", (Object)"1");
        send.put("signatureImageWidth", (Object)"");
        send.put("signatureImageHeight", (Object)"");
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CONTRACT_SEND.getUrl(), send);
        return resData;
    }

    public String lockContract(String contractId) {
        JSONObject lock = new JSONObject();
        lock.put("contractId", (Object)contractId);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.STORAGE_CONTRACT_LOCK.getUrl(), lock);
        return resData;
    }

    public String scan(String frontStr, String backStr) {
        JSONObject send = new JSONObject();
        send.put("identityImage", (Object)frontStr);
        if (StringUtils.isNotEmpty((String)backStr)) {
            send.put("identityBackImage", (Object)backStr);
        }
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CREDENTIAL_VERIFY_OCR_ID_CARD.getUrl(), send);
        return resData;
    }

    public String auth(String mobile, String idCard, String name) {
        JSONObject send = new JSONObject();
        send.put("name", (Object)name);
        send.put("identity", (Object)idCard);
        send.put("mobile", (Object)mobile);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CREDENTIAL_VERIFY.getUrl(), send);
        return resData;
    }

    public String authCard2Info(String idCard, String name) {
        JSONObject send = new JSONObject();
        send.put("name", (Object)name);
        send.put("identity", (Object)idCard);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CREDENTIAL_VERIFY_IDENTITY2.getUrl(), send);
        return resData;
    }

    public String faceAuth(String name, String identity, String data1) {
        JSONObject send = new JSONObject();
        send.put("name", (Object)name);
        send.put("identity", (Object)identity);
        send.put("data1", (Object)data1);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.CREDENTIAL_VERIFY_PERSONAL_IDENTITY3_FACE.getUrl(), send);
        return resData;
    }

    public String sendBankCode(String account, String name, String identity, String bankCard, String mobile) {
        JSONObject send = new JSONObject();
        send.put("account", (Object)account);
        send.put("name", (Object)name);
        send.put("identity", (Object)identity);
        send.put("bankCard", (Object)bankCard);
        send.put("mobile", (Object)mobile);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.REAL_NAME_PERSONAL_IDENTITY4_VCODE_SENDER.getUrl(), send);
        return resData;
    }

    public String verifyBankCode(String code, String personalIdentity4Key) {
        JSONObject send = new JSONObject();
        send.put("vcode", (Object)code);
        send.put("personalIdentity4Key", (Object)personalIdentity4Key);
        String resData = this.handleReq(HttpMethodEnum.post.name(), MethodEnum.REAL_NAME_PERSONAL_IDENTITY4_VCODE_VERIFY.getUrl(), send);
        return resData;
    }

    public String getParam() {
        return this.param;
    }

    public String getDeveloperId() {
        return this.developerId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getUrlSignParams() {
        return this.urlSignParams;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setDeveloperId(String developerId) {
        this.developerId = developerId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setUrlSignParams(String urlSignParams) {
        this.urlSignParams = urlSignParams;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSQUtil)) {
            return false;
        }
        SSQUtil other = (SSQUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$param = this.getParam();
        String other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        String this$developerId = this.getDeveloperId();
        String other$developerId = other.getDeveloperId();
        if (this$developerId == null ? other$developerId != null : !this$developerId.equals(other$developerId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$urlSignParams = this.getUrlSignParams();
        String other$urlSignParams = other.getUrlSignParams();
        if (this$urlSignParams == null ? other$urlSignParams != null : !this$urlSignParams.equals(other$urlSignParams)) {
            return false;
        }
        String this$serverHost = this.getServerHost();
        String other$serverHost = other.getServerHost();
        return !(this$serverHost == null ? other$serverHost != null : !this$serverHost.equals(other$serverHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SSQUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        String $developerId = this.getDeveloperId();
        result = result * 59 + ($developerId == null ? 43 : $developerId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $urlSignParams = this.getUrlSignParams();
        result = result * 59 + ($urlSignParams == null ? 43 : $urlSignParams.hashCode());
        String $serverHost = this.getServerHost();
        result = result * 59 + ($serverHost == null ? 43 : $serverHost.hashCode());
        return result;
    }

    public String toString() {
        return "SSQUtil(param=" + this.getParam() + ", developerId=" + this.getDeveloperId() + ", privateKey=" + this.getPrivateKey() + ", urlSignParams=" + this.getUrlSignParams() + ", serverHost=" + this.getServerHost() + ")";
    }
}

