package cn.com.duiba.youqian.center.api.enums;

import cn.com.duiba.youqian.center.api.entity.EmpPermission;
import cn.com.duiba.youqian.center.api.entity.RolePermission;
import lombok.Getter;

/**
 * @author tengtuox
 * @date 2020/1/2
 * @description 权限点
 */
@Getter
public enum EnumPermission {

    OPEN_ORDER(1, 2, "开单"),
    SEE_ORGANIZATION_CONTRACT(2, 1, "查看部门的所有合同"),
    SEE_MERCHANT_CONTRACT(3, 1, "查看商户下所有合同"),
    ;

    private Integer permissionId;

    /**
     * 0-都不是
     * 1-角色权限
     * 2-员工权限
     */
    private Integer type;

    private String desc;

    EnumPermission(Integer permissionId, Integer type, String desc) {
        this.permissionId = permissionId;
        this.type = type;
        this.desc = desc;
    }

    public RolePermission getRolePermission(Long merchant) {
        RolePermission rolePermission = new RolePermission();
        rolePermission.setMerchantId(merchant);
        rolePermission.setPermissionId(permissionId);

        return rolePermission;
    }

    public EmpPermission getEmpPermission(Long merchant) {
        EmpPermission empPermission = new EmpPermission();
        empPermission.setMerchantId(merchant);
        empPermission.setPermissionId(permissionId);;

        return empPermission;
    }

}
