package cn.com.duiba.youqian.center.api.exception;

import lombok.Getter;

/**
 * @author tengtuox
 * @date 2019/12/27
 * @description: 错误码
 */
@Getter
public enum StandardCode {

    SUCCESS(0, "success"),
    UNKNOWN_ERROR(500, "系统繁忙"),
    PARAM_ERROR(700, "参数错误"),


    // User错误10开头
    USER_NOT_EXISTS(100001, "用户不存在"),
    PASSWORD_ERROR(100002, "账号或密码错误"),
    USER_ALREADY_EXISTS(100003, "用户已存在"),

    // Merchant 11开头
    MERCHANT_NOT_EXISTS(110001, "商户不存在"),
    EMPLOYEE_ALREADY_HAS_MERCHANT(110002, "员工已经加入了一个商户, 不能重复加入"),
    EMPLOYEE_NOT_EXISTS(110003, "员工不存在"),
    MERCHANT_ALREADY_EXISTS(110004, "商户名称已存在"),
    SIGN_ENTITY_NOT_EXISTS(110005, "签约主体不存在"),
    ORG_ALREADY_EXISTS(110006, "组织已存在"),

    // Manage 12开头
    MANAGE_USER_NOT_EXISTS(120001, "用户不存在"),
    MANAGE_PASSWORD_ERROR(120002, "账号或密码错误"),
    MANAGE_USER_ALREADY_EXISTS(120003, "用户已存在"),

    // Order 13开头
    ORDER_NOT_EXISTS(130001, "订单不存在"),
    ;

    private Integer code;

    private String strCode;

    private String description;

    StandardCode(Integer code, String description) {
        this.code = code;
        this.strCode = String.valueOf(code);
        this.description = description;
    }
}
