/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.youqian.center.api.enums;

import cn.com.duiba.youqian.center.api.entity.RoleMenu;
import cn.com.duiba.youqian.center.api.entity.RolePermission;
import cn.com.duiba.youqian.center.api.enums.EnumMenu;
import cn.com.duiba.youqian.center.api.enums.EnumPermission;
import cn.com.duiba.youqian.center.api.result.merchant.RoleVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public enum EnumRole {
    ADMIN("\u7ba1\u7406\u5458", EnumMenu.merchantMenuList(), Collections.singletonList(EnumPermission.SEE_MERCHANT_CONTRACT), 3),
    SALESMAN("\u5458\u5de5", Arrays.asList(EnumMenu.SALE, EnumMenu.ORDER_CONTRACT, EnumMenu.GOODS, EnumMenu.CUSTOMER), Collections.emptyList(), 1),
    ORG_ADMIN("\u90e8\u95e8\u7ecf\u7406", Arrays.asList(EnumMenu.SALE, EnumMenu.ORDER_CONTRACT, EnumMenu.GOODS, EnumMenu.CUSTOMER), Collections.singletonList(EnumPermission.SEE_ORGANIZATION_CONTRACT), 2);

    private String roleName;
    private List<EnumMenu> defaultMenus;
    private List<EnumPermission> defaultPermissions;
    private Integer roleId;

    private EnumRole(String roleName, List<EnumMenu> defaultMenus, List<EnumPermission> defaultPermissions, Integer roleId) {
        this.roleName = roleName;
        this.defaultMenus = defaultMenus;
        this.defaultPermissions = defaultPermissions;
        this.roleId = roleId;
    }

    public static List<RoleVO> getInitRole(Long merchantId) {
        ArrayList<RoleVO> roleList = new ArrayList<RoleVO>(EnumRole.values().length);
        for (EnumRole e : EnumRole.values()) {
            RoleVO role = new RoleVO();
            role.setRoleName(e.getRoleName());
            role.setMerchantId(merchantId);
            ArrayList<RoleMenu> roleMenus = new ArrayList<RoleMenu>(e.defaultMenus.size());
            for (EnumMenu menu : e.defaultMenus) {
                RoleMenu roleMenu = menu.getRoleMenu(merchantId);
                roleMenus.add(roleMenu);
            }
            role.setMenuList(roleMenus);
            if (CollectionUtils.isNotEmpty(e.defaultPermissions)) {
                ArrayList<RolePermission> rolePermissions = new ArrayList<RolePermission>(e.defaultPermissions.size());
                for (EnumPermission permission : e.defaultPermissions) {
                    RolePermission rolePermission = permission.getRolePermission(merchantId);
                    rolePermissions.add(rolePermission);
                }
                role.setPermissionList(rolePermissions);
            }
            roleList.add(role);
        }
        return roleList;
    }

    public static int getRoleByName(String roleName) {
        for (EnumRole e : EnumRole.values()) {
            if (!e.getRoleName().equals(roleName)) continue;
            return e.getRoleId() + 1;
        }
        return SALESMAN.getRoleId();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public List<EnumMenu> getDefaultMenus() {
        return this.defaultMenus;
    }

    public List<EnumPermission> getDefaultPermissions() {
        return this.defaultPermissions;
    }

    public Integer getRoleId() {
        return this.roleId;
    }
}

