package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.EntityAuth;
import cn.com.duiba.youqian.center.api.entity.SignEntity;
import cn.com.duiba.youqian.center.api.request.merchant.ApplyEntCertRequest;
import cn.com.duiba.youqian.center.api.request.merchant.SearchSignEntityRequest;
import cn.com.duiba.youqian.center.api.result.PageResult;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/7
 * @description
 */
@AdvancedFeignClient
public interface RemoteSignEntityService {

    /**
     * 添加签约主体
     *
     * @param signEntity signEntity
     * @return signEntityId
     * @throws BizException 签约主体已存在
     */
    Long add(SignEntity signEntity) throws BizException;

    /**
     * 更新签约主体
     *
     * @param signEntity signEntity
     * @throws BizException 签约主体不存在
     */
    void update(SignEntity signEntity) throws BizException;

    /**
     * 获取签约主体
     *
     * @param signEntityId signEntityId
     * @return SignEntity
     * @throws BizException 签约主体不存在
     */
    SignEntity get(Long signEntityId) throws BizException;

    /**
     * 根据商户ID获取所有签约主体
     *
     * @param merchantId merchantId
     * @return List<SignEntity>
     */
    List<SignEntity> getByMerchantId(Long merchantId) throws BizException;

    /**
     * 分页搜索签约主体
     *
     * @param request request
     * @return PageResult<SignEntity>
     */
    PageResult<SignEntity> pageList(SearchSignEntityRequest request) throws BizException;

    /**
     * 根据实体名称查找
     *
     * @param entityName entityName
     * @return SignEntity
     */
    SignEntity getByEntityName(String entityName) throws BizException;

    /**
     * 新增签约主体实名信息
     *
     * @param entityAuth entityAuth
     * @throws BizException 证件号不匹配
     */
    Long addEnt(EntityAuth entityAuth) throws BizException;

    /**
     * 法人3要素校验 + 申请企业证书
     *
     * @param request request
     * @return 证书编号
     * @throws BizException 法人三要素不匹配/短语验证码不匹配
     */
    String applyEntCert(ApplyEntCertRequest request) throws BizException;

}
