/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.youqian.center.api.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.youqian.center.api.entity.RoleMenu;
import cn.com.duiba.youqian.center.api.exception.StandardCode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public enum EnumMenu {
    SALE(1, "\u9500\u552e\u7ba1\u7406", 1, 0, 1, 1, true),
    ORDER_CONTRACT(11, "\u5408\u7ea6\u5217\u8868", 2, 1, 1, 2, true),
    CUSTOMER(14, "\u6211\u7684\u5ba2\u6237", 2, 1, 1, 3, true),
    GOODS(13, "\u5546\u54c1\u5217\u8868", 2, 1, 1, 4, true),
    CONTRACT_TEMPLATE(12, "\u6211\u7684\u6a21\u677f", 2, 1, 1, 5, true),
    TEMPLATE_ALL(15, "\u6a21\u677f\u5e93", 2, 1, 1, 6, true),
    SYSTEM(2, "\u7cfb\u7edf\u7ba1\u7406", 1, 0, 1, 7, true),
    EMPLOYEE(23, "\u5458\u5de5\u8d26\u53f7", 2, 2, 1, 8, true),
    ORGANIZATION(21, "\u90e8\u95e8\u7ba1\u7406", 2, 2, 1, 9, true),
    APPROVAL(22, "\u5ba1\u6279\u7ba1\u7406", 2, 2, 1, 10, true),
    SIGN_ENTITY(24, "\u7b7e\u7ea6\u4e3b\u4f53", 2, 2, 1, 11, true),
    BUY(3, "\u91c7\u8d2d\u7ba1\u7406", 1, 0, 1, 12, true),
    BUY_ORDER(31, "\u8ba2\u5355\u7ba1\u7406", 2, 3, 1, 13, true),
    PLATFORM_MERCHANT(4, "\u5546\u6237\u7ba1\u7406", 1, 0, 2, 14, true),
    MERCHANT_LIST(41, "\u5546\u6237\u5217\u8868", 2, 4, 2, 15, true),
    PLATFORM_SIGN_ENTITY(42, "\u7b7e\u7ea6\u4e3b\u4f53", 3, 41, 2, 16, false),
    PLATFORM_ENTITY_AUTH(411, "\u4f01\u4e1a\u8ba4\u8bc1", 3, 41, 2, 17, false),
    USER(6, "\u7528\u6237\u7ba1\u7406", 1, 0, 2, 18, true),
    SELL_ACCOUNT(62, "\u5356\u65b9\u8d26\u53f7", 1, 6, 2, 19, true),
    BUY_ACCOUNT(61, "\u4e70\u65b9\u8d26\u53f7", 1, 6, 2, 20, true),
    PLATFORM_ACCOUNT(63, "\u5e73\u53f0\u8d26\u53f7", 1, 6, 2, 21, true),
    PLATFORM_SYSTEM(5, "\u5e73\u53f0\u7ba1\u7406", 1, 0, 2, 22, true),
    PLATFORM_ROLE(51, "\u89d2\u8272\u7ba1\u7406", 2, 5, 2, 23, true),
    TEMPLATE(7, "\u5408\u540c\u6a21\u677f\u5e93", 2, 5, 2, 24, true);

    private Integer menuId;
    private String menuName;
    private Integer level;
    private Integer parentMenuId;
    private Integer type;
    private boolean show;
    private Integer order;

    private EnumMenu(Integer menuId, String menuName, Integer level, Integer parentMenuId, Integer type, Integer order, boolean show) {
        this.menuId = menuId;
        this.menuName = menuName;
        this.level = level;
        this.parentMenuId = parentMenuId;
        this.type = type;
        this.show = show;
        this.order = order;
    }

    public static List<EnumMenu> merchantMenuList() {
        ArrayList<EnumMenu> list = new ArrayList<EnumMenu>();
        for (EnumMenu e : EnumMenu.values()) {
            if (e.getType() != 1) continue;
            list.add(e);
        }
        list.sort(Comparator.comparingInt(o -> o.order));
        return list;
    }

    public static EnumMenu getByMenuId(Integer menuId) throws BizException {
        for (EnumMenu enumMenu : EnumMenu.values()) {
            if (!enumMenu.getMenuId().equals(menuId)) continue;
            return enumMenu;
        }
        throw new BizException("\u83dc\u5355\u4e0d\u5b58\u5728").withCode(StandardCode.PARAM_ERROR.getStrCode());
    }

    public RoleMenu getRoleMenu(Long merchantId) {
        RoleMenu roleMenu = new RoleMenu();
        roleMenu.setMerchantId(merchantId);
        roleMenu.setParentMenuId(this.parentMenuId);
        roleMenu.setMenuId(this.menuId);
        roleMenu.setMenuLevel(this.level);
        roleMenu.setMenuName(this.menuName);
        return roleMenu;
    }

    public static List<EnumMenu> roleManagerMenu() {
        ArrayList<EnumMenu> list = new ArrayList<EnumMenu>();
        for (EnumMenu e : EnumMenu.values()) {
            if (e.getType() != 2) continue;
            list.add(e);
        }
        list.sort(Comparator.comparingInt(o -> o.order));
        return list;
    }

    public Integer getMenuId() {
        return this.menuId;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public Integer getLevel() {
        return this.level;
    }

    public Integer getParentMenuId() {
        return this.parentMenuId;
    }

    public Integer getType() {
        return this.type;
    }

    public boolean isShow() {
        return this.show;
    }

    public Integer getOrder() {
        return this.order;
    }
}

