package cn.com.duiba.youqian.center.api.enums;

import lombok.Getter;

@Getter
public enum MethodEnum {
    REGISTER("/user/reg/", "注册个人(企业)用户申请证书", true),
    CERT("/user/getCert/", "查询证书编号"),
    PERSONAL_CREDENTIAL("/user/getPersonalCredential/", "查询个人用户证件信息"),
    ENTERPRISE_CREDENTIAL("/user/getEnterpriseCredential/", "查询企业用户证件信息"),
    ASYNC_APPLY_CERT("/user/async/applyCert/status/", "异步申请状态查询"),
    CERT_INFO("/user/cert/info/", "获取证书详细信息"),
    STORAGE_UPLOAD("/storage/upload/", "上传合同文件", true),
    STORAGE_DOWNLOAD("/storage/download/", "下载文件"),
    STORAGE_CONTRACT_UPLOAD("/storage/contract/upload/", "上传并创建合同", true),
    CONTRACT_SEND("/contract/send/", "发送合同（即手动签，指定图片大小）", true),
    STORAGE_CONTRACT_LOCK("/storage/contract/lock/", "锁定并结束合同", true),
    CONTRACT_DOWNLOAD("/contract/download/", "下载合同文件"),
    CREDENTIAL_VERIFY_OCR_ID_CARD("/credentialVerify/ocrIDCard/", "身份OCR识别", true),
    CREDENTIAL_VERIFY_PERSONAL_IDENTITY3_FACE("/credentialVerify/personal/identity3/face/", "人脸对比验证", true),
    REAL_NAME_PERSONAL_IDENTITY4_VCODE_SENDER("/realName/personal/identity4/vcode/sender/", "银行卡四要素手机验证码", true),
    REAL_NAME_PERSONAL_IDENTITY4_VCODE_VERIFY("/realName/personal/identity4/vcode/verify/", "银行卡四要素验证码校验", true),
    ENT_4_VERIFY("/credentialVerify/enterprise/identity4/", "企业四要素认证", true),
    ENT_REG("/user/reg/", "企业注册", true),
    ENT_GEN_SEAL("/signatureImage/user/create/", "生成印章"),
    ENT_SEAL_DOWNLOAD("/signatureImage/user/download/", "下载印章"),
    LICENSE_OCR("/credentialVerify/enterprise/businessLicenseOCR/", "营业执照OCR", true),
    CONTRACT_PREVIEW_URL("/contract/getPreviewURL/", "获取合同预览页", false),
    ENT_SEAL_UPLOAD("/signatureImage/user/upload/", "上传印章", false),

    CREDENTIAL_VERIFY("/credentialVerify/personal/identity3/mobile/", "身份证三要素认证", true),
    CREDENTIAL_VERIFY_IDENTITY2("/credentialVerify/personal/identity2/", "身份证二要素认证", true);

    private String url;
    private String msg;
    private boolean needLog = false;

    MethodEnum(String url, String msg) {
        this.url = url;
        this.msg = msg;
    }

    MethodEnum(String url, String msg, boolean needLog) {
        this.url = url;
        this.msg = msg;
        this.needLog = needLog;
    }
}
