package cn.com.duiba.youqian.center.api.request.order;

import cn.com.duiba.youqian.center.api.annotation.TempField;
import cn.com.duiba.youqian.center.api.request.template.TemplateReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;
import java.util.List;

@Data
public class OrderInfoRequest implements Serializable {

    @ApiModelProperty("开单人ID")
    private Long createUserId;

    @ApiModelProperty("订单支付人")
    private Long payUserId;

    @NotBlank(message = "买家名字不能为空")
    @ApiModelProperty(value = "买家名字", required = true)
    private String name;

    @ApiModelProperty(value = "买家列表的customerID", required = true)
    private String customerId;

    @NotBlank(message = "卖家ID不能为空")
    @ApiModelProperty(value = "卖家id", required = true)
    private Integer shellUserId;

    @ApiModelProperty(value = "签约主体id", required = true)
    private Integer signEntityId;

    @ApiModelProperty(value = "买家手机号", required = true)
    private String phone;

    @ApiModelProperty(value = "订单原价", required = true)
    private String originPrice;

    @ApiModelProperty(value = "商户ID", required = true)
    private Integer merchantId;

    @ApiModelProperty(value = "组织ID", required = true)
    private Integer orgId;

    @ApiModelProperty(value = "订单种类数目", required = true)
    private String itemCount;

    @ApiModelProperty(value = "货物数量", required = true)
    private String goodsCount;

    @ApiModelProperty(value = "实际价格", required = true)
    private String price;

    @ApiModelProperty(value = "优惠的价格", required = true)
    private String reducePrice;

    @ApiModelProperty(value = "模板ID",required = true)
    private Long templateId;

    @ApiModelProperty(value = "其他预定事项",required = true)
    private String otherDesc;

    @ApiModelProperty(value = "定金",required = true)
    private String firstPayment;

    @ApiModelProperty(value = "定金付款时间",required = true)
    private String firstPaymentTime;

    @ApiModelProperty(value = "尾款",required = true)
    private String lastPayment;

    @ApiModelProperty(value = "尾款付款时间",required = true)
    private String lastPaymentTime;

    @ApiModelProperty(value = "付款金额",required = true)
    private String payment;

    @ApiModelProperty(value = "付款时间",required = true)
    private String paymentTime;

    @ApiModelProperty(value = "运费",required = true)
    private String freight;

    @ApiModelProperty(value = "物流运输",required = true)
    private String transportWay;

    @ApiModelProperty(value = "交货时间",required = true)
    private String deliveryTime;

    @ApiModelProperty(value = "交货地址",required = true)
    private String deliveryAddress;

    @ApiModelProperty(value = "是否有定金",required = true)
    private Boolean isPayment;

    @ApiModelProperty(value = "税费",required = true)
    private String tax;

    @ApiModelProperty(value = "是否含税",required = true)
    private Boolean isTax;

    @ApiModelProperty(value = "发票ID",required = true)
    private Integer invoiceId;

    @ApiModelProperty(value = "买家签约类型 1.个人 2.企业",required = true)
    private Integer buyerType;

    @ApiModelProperty(value = "合同参数列表",required = true)
    public List<TemplateReq> tepFieldList;

    @ApiModelProperty(value = "商品列表", required = true)
    private List<GoodsReq> list;

    @ApiModelProperty("签约主体名称")
    private String entityName;

    @ApiModelProperty("自定义订单编号")
    private String orderNo;

    @ApiModelProperty("买家联系人姓名")
    private String buyerContactName;

    @ApiModelProperty("买家联系人手机号")
    private String buyerContactMobile;


}
