package cn.com.duiba.youqian.center.api.request.template;

import cn.com.duiba.youqian.center.api.request.order.GoodsReq;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class TemplateFieldRequest implements Serializable {
    /**
     * 买家的关联ID
     */
    private String customerId;
    /**
     * 模板ID
     */
    private Long templateId;
    /**
     * 模板字段ID
     */
    private List<TemplateReq> tepFieldList;
    /**
     * 商品信息
     */
    private List<GoodsReq> list;
    /**
     * 卖家签约主体
     */
    private Integer sellSignEntityId;
    /**
     * 买家姓名
     */
    private String customerName;
    /**
     * 其他约定事项
     */
    private String otherDesc;
    /**
     * 定金
     */
    private String firstPayment;
    /**
     * 定金付款时间
     */
    private String firstPaymentTime;
    /**
     * 尾款
     */
    private String lastPayment;
    /**
     * 尾款付款时间
     */
    private String lastPaymentTime;
    /**
     * 付款金额
     */
    private String payment;
    /**
     * 付款时间
     */
    private String paymentTime;
    /**
     * 运费
     */
    private String freight;
    /**
     * 物流运输
     */
    private String transportWay;
    /**
     * 交货时间
     */
    private String deliveryTime;
    /**
     * 是否定金
     */
    private Boolean isPayment;
    /**
     * 交货地址
     */
    private String deliveryAddress;
    /**
     * 税费
     */
    private String tax;
    /**
     * 是否含税
     */
    private Boolean isTax;
    /**
     * 发票类型
     */
    private Integer invoiceId;
    /**
     * 优惠价格
     */
    private String reducePrice;
    /**
     * 修改后价格
     */
    private String price;
}
