package cn.com.duiba.youqian.center.api.request.template;

import cn.com.duiba.youqian.center.api.annotation.TempField;
import cn.com.duiba.youqian.center.api.enums.TemplateFieldEnum;
import lombok.Data;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class TemplateOtherFieldVO implements Serializable {
    @TempField(name = TemplateFieldEnum.OTHER_DESC)
    private String otherDesc;

    @TempField(name = TemplateFieldEnum.FIRST_PAYMENT)
    private String firstPayment;

    @TempField(name = TemplateFieldEnum.FIRST_PAYMENT_TIME)
    private String firstPaymentTime;

    @TempField(name = TemplateFieldEnum.LAST_PAYMENT)
    private String lastPayment;

    @TempField(name = TemplateFieldEnum.LAST_PAYMENT_TIME)
    private String lastPaymentTime;

    @TempField(name = TemplateFieldEnum.PAYMENT)
    private String payment;

    @TempField(name = TemplateFieldEnum.PAYMENT_TIME)
    private String paymentTime;

    @TempField(name = TemplateFieldEnum.FREIGHT)
    private String freight;

    @TempField(name = TemplateFieldEnum.TRANSPORT_WAY)
    private String transportWay;

    private Integer transportWayIndex;

    @TempField(name = TemplateFieldEnum.DELIVERY_TIME)
    private String deliveryTime;

    @TempField(name = TemplateFieldEnum.DELIVERY_ADDRESS)
    private String deliveryAddress;

    @TempField(name = TemplateFieldEnum.IS_PAYMENT)
    private Boolean isPayment;

    @TempField(name = TemplateFieldEnum.TAX)
    private String tax;

    @TempField(name = TemplateFieldEnum.IS_TAX)
    private Boolean isTax;

    @TempField(name = TemplateFieldEnum.INVOICE_ID)
    private Integer invoiceId;

    public TemplateOtherFieldVO format(){
        this.setTransportWay(TransportWayEnum.get(StringUtils.isEmpty(this.getTransportWay())?null:Integer.parseInt(this.getTransportWay())));
        this.setFirstPaymentTime(FirstPaymentEnum.get(StringUtils.isEmpty(this.getFirstPaymentTime())?null:Integer.parseInt(this.getFirstPaymentTime())));
        this.setPaymentTime(LastPaymentEnum.get(StringUtils.isEmpty(this.getPaymentTime())?null:Integer.parseInt(this.getPaymentTime())));
        this.setLastPaymentTime(LastPaymentEnum.get(StringUtils.isEmpty(this.getLastPaymentTime())?null:Integer.parseInt(this.getLastPaymentTime())));
        return this;
    }

    @Getter
    public enum TransportWayEnum{
        TRANSPORT_1(0,"甲方上门自提"),
        TRANSPORT_2(1,"乙方送货上门"),
        TRANSPORT_3(2,"以【备注】约定为准");
        private Integer code;
        private String msg;
        TransportWayEnum(Integer code,String msg){
            this.code = code;
            this.msg = msg;
        }
        public static String get(Integer code){
            code = code == null?0:code;
            for(TransportWayEnum transport : values()){
                if(code.equals(transport.getCode())){
                    return transport.getMsg();
                }
            }
            return "";
        }

    }
    @Getter
    enum FirstPaymentEnum{
        PAYMENT_1(0,"发货前7个工作日内"),
        PAYMENT_2(1,"以【备注】约定为准");
        private Integer code;
        private String msg;
        FirstPaymentEnum(Integer code,String msg){
            this.code = code;
            this.msg = msg;
        }
        public static String get(Integer code){
            code = code == null?0:code;
            for(FirstPaymentEnum firstPaymentEnum : values()){
                if(code.equals(firstPaymentEnum.getCode())){
                    return firstPaymentEnum.getMsg();
                }
            }
            return "";
        }
    }
    @Getter
    enum LastPaymentEnum{
        PAYMENT_1(0,"收货后7个工作日内"),
        PAYMENT_2(1,"月结(次月前7个工作日内)"),
        PAYMENT_3(2,"以【备注】约定为准");
        private Integer code;
        private String msg;
        LastPaymentEnum(Integer code,String msg){
            this.code = code;
            this.msg = msg;
        }
        public static String get(Integer code){
            code = code == null?0:code;
            for(LastPaymentEnum lastPaymentEnum : values()){
                if(code.equals(lastPaymentEnum.getCode())){
                    return lastPaymentEnum.getMsg();
                }
            }
            return "";
        }
    }

}
