package cn.com.duiba.youqian.center.api.request.user;

import cn.com.duiba.youqian.center.api.entity.PlatformUser;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiachenhang
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class PlatformUserRequest extends PlatformUser implements Serializable {

    @ApiModelProperty("卖家身份")
    private List<Integer> role;

    @ApiModelProperty("公司名")
    private String companyName;

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("组织ID")
    private Long orgId;

    @ApiModelProperty("是否开单人")
    private Integer isSignPerson;

    @ApiModelProperty("是否开单人")
    private Integer isYQMerchant;

    @ApiModelProperty("是否签约主体")
    private Boolean isSignEntity = false;

    @ApiModelProperty("是否提醒")
    private Boolean isFirstLogin = false;
}
