/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.youqian.center.api.enums;

import java.math.BigDecimal;

public enum InvoiceEnum {
    DEFAULT_VALUE_ADD_INVOICE("-1", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", "0.15", 1),
    DEFAULT_NORMAL_INVOICE("-2", "\u666e\u901a\u53d1\u7968", "0.03", 2);

    private String id;
    private String name;
    private String invoice;
    private Integer type;

    private InvoiceEnum(String id, String name, String invoice, Integer type) {
        this.id = id;
        this.name = name;
        this.invoice = invoice;
        this.type = type;
    }

    public static boolean get(Integer type, String invoice) {
        for (InvoiceEnum invoiceEnum : InvoiceEnum.values()) {
            if (!invoiceEnum.getType().equals(type) || !invoiceEnum.getInvoice().equals(invoice)) continue;
            return true;
        }
        return false;
    }

    public static InvoiceEnum get(Integer type) {
        for (InvoiceEnum invoiceEnum : InvoiceEnum.values()) {
            if (!invoiceEnum.getType().equals(type)) continue;
            return invoiceEnum;
        }
        return null;
    }

    public static InvoiceEnum get(String id) {
        for (InvoiceEnum invoiceEnum : InvoiceEnum.values()) {
            if (!id.equals(invoiceEnum.getId())) continue;
            return invoiceEnum;
        }
        return null;
    }

    public static String getByTaxPointStr(String id) {
        InvoiceEnum invoiceEnum = InvoiceEnum.get(id);
        if (invoiceEnum != null) {
            return invoiceEnum.getName() + ",\u7a0e\u70b9:" + new BigDecimal(invoiceEnum.getInvoice()).multiply(new BigDecimal(100)).setScale(0) + "%";
        }
        return null;
    }

    public static String getTaxPointById(String id) {
        InvoiceEnum invoiceEnum = InvoiceEnum.get(id);
        if (invoiceEnum != null) {
            return new BigDecimal(invoiceEnum.getInvoice()).multiply(new BigDecimal(100)).setScale(0) + "%";
        }
        return null;
    }

    public static String format(Integer type) {
        InvoiceEnum invoiceEnum = InvoiceEnum.get(type);
        return invoiceEnum.getName() + ",\u7a0e\u70b9:" + new BigDecimal(invoiceEnum.getInvoice()).multiply(new BigDecimal(100)).setScale(0) + "%";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public Integer getType() {
        return this.type;
    }
}

