package cn.com.duiba.youqian.center.api.entity;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 描述：merchant_invoice模型
 *
 * @author xiachenhang
 * @date 2020-03-02 17:12:47
 */
@Data
public class MerchantInvoice implements Serializable{

    /**
     * 主键ID
     */
    private Integer id;
    /**
     * 商户ID
     */
    private Long merchantId;
    /**
     * 发票类型，1-增值税专用发票，2-普通发票
     */
    @ApiModelProperty("发票类型，1-增值税专用发票，2-普通发票")
    private Byte invoiceType;
    /**
     * 税点,如0.15
     */
    @ApiModelProperty("税点,如0.15")
    private BigDecimal taxPoint;

}