package cn.com.duiba.youqian.center.api.enums;

import lombok.Getter;

@Getter
public enum InvoiceEnum {
    /**
     * 系统默认发票方案
     */
    DEFAULT_VALUE_ADD_INVOICE("-1","增值税专用发票","0.15",1),
    DEFAULT_NORMAL_INVOICE   ("-2" ,"普通发票","0.03",2);

    private String id;
    private String name;
    private String invoice;
    private Integer type;

    InvoiceEnum(String id,String name,String invoice,Integer type){
        this.id = id;
        this.name = name;
        this.invoice = invoice;
        this.type = type;
    }

    public static boolean get(Integer type,String invoice){
        for(InvoiceEnum invoiceEnum:values()){
            if(invoiceEnum.getType().equals(type) && invoiceEnum.getInvoice().equals(invoice)){
                return true;
            }
        }
        return false;
    }
}
