package cn.com.duiba.youqian.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.youqian.center.api.entity.GoodsSpec;
import cn.com.duiba.youqian.center.api.request.goods.GoodsRequest;
import cn.com.duiba.youqian.center.api.result.goods.GoodsVO;

import java.util.List;

/**
 * @author tengtuox
 * @date 2020/1/3
 * @description
 */
@AdvancedFeignClient
public interface RemoteGoodsService {

    /**
     * 查询商户下的商品
     * @param name   商品名
     * @param userId 操作用户ID
     * @return
     */
    List<GoodsVO> getMerchantGoods(String name, Long userId);

    /**
     * 根据条件查询商品的详细信息
     * @param goodsRequest 商品查询条件
     * @return
     */
    List<GoodsVO> getGoods(GoodsRequest goodsRequest);

    /**
     * 根据商户ID获取所有商品
     *
     * @param merchantId merchantId
     * @return List<GoodsSpec>
     */
    List<GoodsSpec> getGoodsSpec(Long merchantId) throws BizException;

}
