package cn.com.duiba.youqian.center.api.request.manage;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/2/14
 * @description
 */
@Data
public class UpdateManageRoleRequest implements Serializable {
    private static final long serialVersionUID = 2813569409857765574L;

    @Min(1)
    @NotNull
    @ApiModelProperty(value = "角色ID", required = true)
    private Long roleId;

    @NotBlank
    @ApiModelProperty(value = "角色名称", required = true)
    private String roleName;

    @NotNull
    @Size(min = 1)
    @ApiModelProperty(value = "角色菜单列表", required = true)
    private List<Integer> menuIdList;

    @ApiModelProperty("角色业务权限列表")
    private List<Integer> permissionIdList;

}
